<?php

$hudson_edge_icon_collections = hudson_edge_return_icon_collections();

$edgt_blog_categories = array();
$categories           = get_categories();
foreach ( $categories as $category ) {
	$edgt_blog_categories[ $category->term_id ] = $category->name;
}

//Slide Type

$edgtSlideType = new HudsonEdgeMetaBox(
	"slides",
	esc_html__( "Slide Background Type", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"slides_type",
	$edgtSlideType
);

$edgt_slide_background_type = new HudsonEdgeMetaField(
	"imagevideo",
	"edgt_slide-background-type",
	"image",
	esc_html__( "Slide Background Type", 'hudson' ),
	esc_html__( "Do you want to upload an image or video?", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "#edgtf-meta-box-slides_video_settings",
		"dependence_show_on_yes" => "#edgtf-meta-box-slides_image_settings"
	)
);
$edgtSlideType->addChild(
	"edgt_slide-background-type",
	$edgt_slide_background_type
);

//Slide Image

$edgtSlideImageSettings = new HudsonEdgeMetaBox(
	"slides",
	esc_html__( "Slide Background Image", 'hudson' ),
	"edgt_slide-background-type",
	array( "video" )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"slides_image_settings",
	$edgtSlideImageSettings
);

$edgt_slide_image = new HudsonEdgeMetaField(
	"image",
	"edgt_slide-image",
	"",
	esc_html__( "Slide Image", 'hudson' ),
	esc_html__( "Choose background image", 'hudson' )
);
$edgtSlideImageSettings->addChild(
	"edgt_title-image",
	$edgt_slide_image
);

$edgt_slide_overlay_image = new HudsonEdgeMetaField(
	"image",
	"edgt_slide-overlay-image",
	"",
	esc_html__( "Overlay Image", 'hudson' ),
	esc_html__( "Choose overlay image (pattern) for background image", 'hudson' )
);
$edgtSlideImageSettings->addChild(
	"edgt_slide-overlay-image",
	$edgt_slide_overlay_image
);

//Slide Video

$edgtSlideVideoSettings = new HudsonEdgeMetaBox(
	"slides",
	esc_html__( "Slide Background Video", 'hudson' ),
	"edgt_slide-background-type",
	array( "image" )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"slides_video_settings",
	$edgtSlideVideoSettings
);

$edgt_slide_video_webm = new HudsonEdgeMetaField(
	"text",
	"edgt_slide-video-webm",
	"",
	esc_html__( "Video - webm", 'hudson' ),
	esc_html__( "Path to the webm file that you have previously uploaded in Media Section", 'hudson' )
);
$edgtSlideVideoSettings->addChild(
	"edgt_slide-video-webm",
	$edgt_slide_video_webm
);

$edgt_slide_video_mp4 = new HudsonEdgeMetaField(
	"text",
	"edgt_slide-video-mp4",
	"",
	esc_html__( "Video - mp4", 'hudson' ),
	esc_html__( "Path to the mp4 file that you have previously uploaded in Media Section", 'hudson' )
);
$edgtSlideVideoSettings->addChild(
	"edgt_slide-video-mp4",
	$edgt_slide_video_mp4
);

$edgt_slide_video_ogv = new HudsonEdgeMetaField(
	"text",
	"edgt_slide-video-ogv",
	"",
	esc_html__( "Video - ogv", 'hudson' ),
	esc_html__( "Path to the ogv file that you have previously uploaded in Media Section", 'hudson' )
);
$edgtSlideVideoSettings->addChild(
	"edgt_slide-video-ogv",
	$edgt_slide_video_ogv
);

$edgt_slide_video_image = new HudsonEdgeMetaField(
	"image",
	"edgt_slide-video-image",
	"",
	esc_html__( "Video Preview Image", 'hudson' ),
	esc_html__( "Choose background image that will be visible until video is loaded. This image will be shown on touch devices too.", 'hudson' )
);
$edgtSlideVideoSettings->addChild(
	"edgt_slide-video-image",
	$edgt_slide_video_image
);

$edgt_slide_video_overlay = new HudsonEdgeMetaField(
	"yesempty",
	"edgt_slide-video-overlay",
	"",
	esc_html__( "Video Overlay Image", 'hudson' ),
	esc_html__( "Do you want to have a overlay image on video? ", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_edgt_slide-video-overlay_container"
	)
);
$edgtSlideVideoSettings->addChild(
	"edgt_slide-video-overlay",
	$edgt_slide_video_overlay
);

$edgt_slide_video_overlay_container = new HudsonEdgeContainer(
	"edgt_slide-video-overlay_container",
	"edgt_slide-video-overlay",
	""
);
$edgtSlideVideoSettings->addChild(
	"edgt_slide_video_overlay_container",
	$edgt_slide_video_overlay_container
);

$edgt_slide_video_overlay_image = new HudsonEdgeMetaField(
	"image",
	"edgt_slide-video-overlay-image",
	"",
	esc_html__( "Overlay Image", 'hudson' ),
	esc_html__( "Choose overlay image (pattern) for background video", 'hudson' )
);
$edgt_slide_video_overlay_container->addChild(
	"edgt_slide-video-overlay-image",
	$edgt_slide_video_overlay_image
);

//Slide General

$edgtSlideGeneral = new HudsonEdgeMetaBox(
	"slides",
	esc_html__( "Slide General", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"slides_layout",
	$edgtSlideGeneral
);

$section_title_1 = new HudsonEdgeTitle(
	'section_title_1',
	esc_html__( 'Slide Text Content', 'hudson' )
);
$edgtSlideGeneral->addChild(
	'section_title_1',
	$section_title_1
);

$edgt_slide_hide_title = new HudsonEdgeMetaField(
	"yesempty",
	"edgt_slide-hide-title",
	"",
	esc_html__( "Hide Slide Title", 'hudson' ),
	esc_html__( "Do you want to hide slide title?", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "#edgtf-meta-box-slides_title, #edgtf_edgt_slide_hide_title_container, #edgtf_edgt_slide_scroll_title_container",
		"dependence_show_on_yes" => ""
	)
);
$edgtSlideGeneral->addChild(
	"edgt_slide-hide-title",
	$edgt_slide_hide_title
);

$edgt_slide_hide_title_container = new HudsonEdgeContainer(
	'edgt_slide_hide_title_container',
	'edgt_slide-hide-title',
	'yes'
);
$edgtSlideGeneral->addChild(
	'edgt_slide_hide_title_container',
	$edgt_slide_hide_title_container
);

$title_link_group = new HudsonEdgeGroup(
	esc_html__( "Title Link", 'hudson' ),
	esc_html__( "Define styles for title", 'hudson' )
);
$edgt_slide_hide_title_container->addChild(
	"title_link_group",
	$title_link_group
);
$row1 = new HudsonEdgeRow();
$title_link_group->addChild(
	"row1",
	$row1
);

$title_link = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-title-link",
	"",
	esc_html__( "Link", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-title-link",
	$title_link
);
$title_target = new HudsonEdgeMetaField(
	"selectsimple",
	"edgt_slide-title-target",
	"_self",
	esc_html__( "Target", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"_self" => esc_html__( "Self", 'hudson' ),
		"_blank" => esc_html__( "Blank", 'hudson' )
	)
);
$row1->addChild(
	"edgt_slide-title-target",
	$title_target
);

$edgt_slide_subtitle = new HudsonEdgeMetaField(
	"text",
	"edgt_slide-subtitle",
	"",
	esc_html__( "Subtitle Text", 'hudson' ),
	esc_html__( "Enter text for subtitle", 'hudson' )
);
$edgtSlideGeneral->addChild(
	"edgt_slide-subtitle",
	$edgt_slide_subtitle
);

$edgt_slide_text = new HudsonEdgeMetaField(
	"text",
	"edgt_slide-text",
	"",
	esc_html__( "Body Text", 'hudson' ),
	esc_html__( "Enter slide body text", 'hudson' )
);
$edgtSlideGeneral->addChild(
	"edgt_slide-text",
	$edgt_slide_text
);

$button1_label = new HudsonEdgeMetaField(
	"text",
	"edgt_slide-button-label",
	"",
	esc_html__( "Button 1 Text", 'hudson' ),
	" Enter text to be displayed on button 1"
);
$edgtSlideGeneral->addChild(
	"edgt_slide-button-label",
	$button1_label
);

$button1_group1 = new HudsonEdgeGroup(
	esc_html__( "Button 1 Link", 'hudson' ),
	""
);
$edgtSlideGeneral->addChild(
	"button1_group1",
	$button1_group1
);

$row1 = new HudsonEdgeRow();
$button1_group1->addChild(
	"row1",
	$row1
);

$button1_link = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button-link",
	"",
	esc_html__( "Link", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button-link",
	$button1_link
);
$button1_target = new HudsonEdgeMetaField(
	"selectsimple",
	"edgt_slide-button-target",
	"_self",
	esc_html__( "Target", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"_self" => esc_html__( "Self", 'hudson' ),
		"_blank" => esc_html__( "Blank", 'hudson' )
	)
);
$row1->addChild(
	"edgt_slide-button-target",
	$button1_target
);

$button2_label = new HudsonEdgeMetaField(
	"text",
	"edgt_slide-button-label2",
	"",
	esc_html__( "Button 2 Text", 'hudson' ),
	" Enter text to be displayed on button 2"
);
$edgtSlideGeneral->addChild(
	"edgt_slide-button-label2",
	$button2_label
);

$button2_group1 = new HudsonEdgeGroup(
	esc_html__( "Button 2 Link", 'hudson' ),
	""
);
$edgtSlideGeneral->addChild(
	"button2_group1",
	$button2_group1
);
$row1 = new HudsonEdgeRow();
$button2_group1->addChild(
	"row1",
	$row1
);

$button2_link = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button-link2",
	"",
	esc_html__( "Link", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button-link2",
	$button2_link
);
$button2_target = new HudsonEdgeMetaField(
	"selectsimple",
	"edgt_slide-button-target2",
	"_self",
	esc_html__( "Target", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"_self" => esc_html__( "Self", 'hudson' ),
		"_blank" => esc_html__( "Blank", 'hudson' )
	)
);
$row1->addChild(
	"edgt_slide-button-target",
	$button2_target
);

$edgt_slide_text_content_top_margin = new HudsonEdgeMetaField(
	"text",
	"edgt_slide_text_content_top_margin",
	"",
	esc_html__( "Text Content Top Margin", 'hudson' ),
	esc_html__( "Enter top margin for text content", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgtSlideGeneral->addChild(
	"edgt_slide_text_content_top_margin",
	$edgt_slide_text_content_top_margin
);

$edgt_slide_text_content_bottom_margin = new HudsonEdgeMetaField(
	"text",
	"edgt_slide_text_content_bottom_margin",
	"",
	esc_html__( "Text Content Bottom Margin", 'hudson' ),
	esc_html__( "Enter bottom margin for text content", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgtSlideGeneral->addChild(
	"edgt_slide_text_content_bottom_margin",
	$edgt_slide_text_content_bottom_margin
);

$section_title_2 = new HudsonEdgeTitle(
	'section_title_2',
	esc_html__( 'Slide Graphics', 'hudson' )
);
$edgtSlideGeneral->addChild(
	'section_title_2',
	$section_title_2
);

$edgt_slide_graphic = new HudsonEdgeMetaField(
	"image",
	"edgt_slide-thumbnail",
	"",
	esc_html__( "Slide Graphic", 'hudson' ),
	esc_html__( "Choose slide graphic", 'hudson' )
);
$edgtSlideGeneral->addChild(
	"edgt_slide-thumbnail",
	$edgt_slide_graphic
);

$edgt_slide_graphic_link = new HudsonEdgeMetaField(
	"text",
	"edgt_slide-thumbnail-link",
	"",
	esc_html__( "Graphic Link", 'hudson' ),
	esc_html__( "Enter URL to link slide graphic", 'hudson' )
);
$edgtSlideGeneral->addChild(
	"edgt_slide-thumbnail-link",
	$edgt_slide_graphic_link
);

$edgt_slide_graphic_top_padding = new HudsonEdgeMetaField(
	"text",
	"edgt_slide_graphic_top_padding",
	"",
	esc_html__( "Graphic Top Padding", 'hudson' ),
	esc_html__( "Enter top padding for slide graphic", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgtSlideGeneral->addChild(
	"edgt_slide_graphic_top_padding",
	$edgt_slide_graphic_top_padding
);

$edgt_slide_graphic_bottom_padding = new HudsonEdgeMetaField(
	"text",
	"edgt_slide_graphic_bottom_padding",
	"",
	esc_html__( "Graphic Bottom Padding", 'hudson' ),
	esc_html__( "Enter bottom padding for slide graphic", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgtSlideGeneral->addChild(
	"edgt_slide_graphic_bottom_padding",
	$edgt_slide_graphic_bottom_padding
);

$section_title_3 = new HudsonEdgeTitle(
	'section_title_3',
	esc_html__( 'General Styling', 'hudson' )
);
$edgtSlideGeneral->addChild(
	'section_title_3',
	$section_title_3
);

$edgt_slide_header_style = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_slide-header-style",
	"",
	esc_html__( "Header Style", 'hudson' ),
	esc_html__( "Header style will be applied when this slide is in focus", 'hudson' ),
	array(
		"light" => esc_html__( "Light", 'hudson' ),
		"dark" => esc_html__( "Dark", 'hudson' )
	)
);
$edgtSlideGeneral->addChild(
	"edgt_slide-header-style",
	$edgt_slide_header_style
);

$edgt_slide_content_background = new HudsonEdgeMetaField(
	"color",
	"edgt_slide-content-background-color",
	"",
	esc_html__( "Slide Content Background Color", 'hudson' ),
	esc_html__( "Choose background color for slide content", 'hudson' )
);
$edgtSlideGeneral->addChild(
	"edgt_slide-content-background-color",
	$edgt_slide_content_background
);

$edgt_slide_graphic_background = new HudsonEdgeMetaField(
	"color",
	"edgt_slide_graphic_background",
	"",
	esc_html__( "Slide Graphic Background Color", 'hudson' ),
	esc_html__( "Choose background color for slide graphic", 'hudson' )
);
$edgtSlideGeneral->addChild(
	"edgt_slide_graphic_background",
	$edgt_slide_graphic_background
);

$edgt_slide_content_graphic_background = new HudsonEdgeMetaField(
	"color",
	"edgt_slide_content_graphic_background",
	"",
	esc_html__( "Background Color Around Slide Content and Graphic", 'hudson' ),
	esc_html__( "Choose background color for box around slide content and graphic", 'hudson' )
);
$edgtSlideGeneral->addChild(
	"edgt_slide_content_graphic_background",
	$edgt_slide_content_graphic_background
);

$edgt_slide_text_content_box_shaddow = new HudsonEdgeMetaField(
	"text",
	"edgt_slide_text_content_box_shaddow",
	"",
	esc_html__( "Box Shadow Around Text Content", 'hudson' ),
	esc_html__( "Enter box shadow for text content box (in format: 2px 2px 2px 2px #000)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgtSlideGeneral->addChild(
	"edgt_slide_text_content_box_shaddow",
	$edgt_slide_text_content_box_shaddow
);

$edgt_slide_content_graphic_box_shaddow = new HudsonEdgeMetaField(
	"text",
	"edgt_slide_content_graphic_box_shaddow",
	"",
	esc_html__( "Box Shadow Around Text Content and Graphic", 'hudson' ),
	esc_html__( "Enter shadow for box around text and graphic (in format: 2px 2px 2px 2px #000)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgtSlideGeneral->addChild(
	"edgt_slide_content_graphic_box_shaddow",
	$edgt_slide_content_graphic_box_shaddow
);

/*
	$edgt_slide_navigation_color = new HudsonEdgeMetaField("color","edgt_slide-navigation-color","",esc_html__( "Navigation Color","Navigation color will be applied when this slide is in focus", 'hudson' ));
	$edgtSlideGeneral->addChild("edgt_slide-navigation-color",$edgt_slide_navigation_color);
*/

$edgt_slide_hide_shadow = new HudsonEdgeMetaField(
	"yesempty",
	"edgt_slide-hide-shadow",
	"",
	esc_html__( "Show Slide Text Shadow", 'hudson' ),
	esc_html__( "Do you want to show text shadow?", 'hudson' )
);
$edgtSlideGeneral->addChild(
	"edgt_slide-hide-shadow",
	$edgt_slide_hide_shadow
);

$edgtSlideBehaviour = new HudsonEdgeMetaBox(
	"slides",
	esc_html__( "Slide Behaviours", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"slides_behaviour",
	$edgtSlideBehaviour
);

$edgt_slide_scroll_to_section = new HudsonEdgeMetaField(
	"text",
	"edgt_slide-anchor-button",
	"",
	esc_html__( "Scroll to Section", 'hudson' ),
	esc_html__( "An arrow will appear to take viewers to the next section of the page. Enter the section anchor here, for example, '#contact'", 'hudson' )
);
$edgtSlideBehaviour->addChild(
	"edgt_slide-anchor-button",
	$edgt_slide_scroll_to_section
);

$edgt_slide_scroll_to_section_position = new HudsonEdgeMetaField(
	"select",
	"edgt_slide-anchor-button_position",
	"in_content",
	esc_html__( "Scroll to Section Icon Position", 'hudson' ),
	esc_html__( "Choose position for anchor icon - scroll to section", 'hudson' ),
	array(
		"in_content" => esc_html__( "In Text Content", 'hudson' ),
		"bottom_of_slider" => esc_html__( "Bottom of the slide", 'hudson' )
	)
);
$edgtSlideBehaviour->addChild(
	"edgt_slide-anchor-button_position",
	$edgt_slide_scroll_to_section_position
);

$section_title_2 = new HudsonEdgeTitle(
	'section_title_2',
	esc_html__( 'Slide Image Animation', 'hudson' )
);
$edgtSlideBehaviour->addChild(
	'section_title_2',
	$section_title_2
);

$edgt_enable_image_animation = new HudsonEdgeMetaField(
	"yesno",
	"edgt_enable_image_animation",
	"no",
	esc_html__( "Enable Image Animation", 'hudson' ),
	esc_html__( "Enabling this option will turn on a motion animation on the slide image", 'hudson' ),
	array(),
	array(
		"dependence"             => "true",
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_edgt_enable_image_animation_container"
	)
);
$edgtSlideBehaviour->addChild(
	'edgt_enable_image_animation',
	$edgt_enable_image_animation
);

$edgt_enable_image_animation_container = new HudsonEdgeContainer(
	"edgt_enable_image_animation_container",
	"edgt_enable_image_animation",
	"no"
);
$edgtSlideBehaviour->addChild(
	"edgt_enable_image_animation_container",
	$edgt_enable_image_animation_container
);

$edgt_enable_image_animation_type = new HudsonEdgeMetaField(
	"select",
	"edgt_enable_image_animation_type",
	"zoom_center",
	esc_html__( "Animation Type", 'hudson' ),
	"",
	array(
		"zoom_center" => esc_html__( "Zoom In Center", 'hudson' ),
		"zoom_top_left" => esc_html__( "Zoom In to Top Left", 'hudson' ),
		"zoom_top_right" => esc_html__( "Zoom In to Top Right", 'hudson' ),
		"zoom_bottom_left" => esc_html__( "Zoom In to Bottom Left", 'hudson' ),
		"zoom_bottom_right" => esc_html__( "Zoom In to Bottom Right", 'hudson' )
	)
);
$edgt_enable_image_animation_container->addChild(
	"edgt_enable_image_animation_type",
	$edgt_enable_image_animation_type
);

$section_title_3 = new HudsonEdgeTitle(
	'section_title_3',
	esc_html__( 'Slide Content Entry Animations', 'hudson' )
);
$edgtSlideBehaviour->addChild(
	'section_title_3',
	$section_title_3
);

$edgt_slide_thumbnail_animation = new HudsonEdgeMetaField(
	"select",
	"edgt_slide-thumbnail-animation",
	"flip",
	esc_html__( "Graphic Entry Animation", 'hudson' ),
	esc_html__( "Choose entry animation for graphic", 'hudson' ),
	array(
		"flip" => esc_html__( "Flip", 'hudson' ),
		"fade" => esc_html__( "Fade In", 'hudson' ),
		"from_bottom" => esc_html__( "From Bottom", 'hudson' ),
		"from_top" => esc_html__( "From Top", 'hudson' ),
		"from_left" => esc_html__( "From Left", 'hudson' ),
		"from_right" => esc_html__( "From Right", 'hudson' ),
		"clip_anim_hor" => esc_html__( "Clip Animation Horizontal", 'hudson' ),
		"clip_anim_ver" => esc_html__( "Clip Animation Vertical", 'hudson' ),
		"clip_anim_puzzle" => esc_html__( "Clip Animation Puzzle", 'hudson' ),
		"without_animation" => esc_html__( "No Animation", 'hudson' )
	)
);
$edgtSlideBehaviour->addChild(
	"edgt_slide-thumbnail-animation",
	$edgt_slide_thumbnail_animation
);

$edgt_slide_content_animation = new HudsonEdgeMetaField(
	"select",
	"edgt_slide-content-animation",
	"all_at_once",
	esc_html__( "Content Entry Animation", 'hudson' ),
	esc_html__( "Choose entry animation for whole slide content group (title, subtitle, text, button)", 'hudson' ),
	array(
		"all_at_once" => esc_html__( "All At Once", 'hudson' ),
		"one_by_one" => esc_html__( "One By One", 'hudson' ),
		"without_animation" => esc_html__( "No Animation", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"all_at_once"       => "",
			"one_by_one"        => "",
			"without_animation" => "#edgtf_edgt_slide_content_animation_container"
		),
		"show"       => array(
			"all_at_once"       => "#edgtf_edgt_slide_content_animation_container",
			"one_by_one"        => "#edgtf_edgt_slide_content_animation_container",
			"without_animation" => ""
		)
	)
);
$edgtSlideBehaviour->addChild(
	"edgt_slide-content-animation",
	$edgt_slide_content_animation
);

$edgt_slide_content_animation_container = new HudsonEdgeContainer(
	"edgt_slide_content_animation_container",
	"edgt_slide-content-animation",
	"without_animation"
);
$edgtSlideBehaviour->addChild(
	"edgt_slide_content_animation_container",
	$edgt_slide_content_animation_container
);

$edgt_slide_content_animation_direction = new HudsonEdgeMetaField(
	"select",
	"edgt_slide-content-animation-direction",
	"from_bottom",
	esc_html__( "Animation Direction", 'hudson' ),
	"",
	array(
		"from_bottom" => esc_html__( "From Bottom", 'hudson' ),
		"from_top" => esc_html__( "From Top", 'hudson' ),
		"from_left" => esc_html__( "From Left", 'hudson' ),
		"from_right" => esc_html__( "From Right", 'hudson' ),
		"fade" => esc_html__( "Fade In", 'hudson' )
	
	)
);
$edgt_slide_content_animation_container->addChild(
	"edgt_slide-content-animation-direction",
	$edgt_slide_content_animation_direction
);

$section_title_4 = new HudsonEdgeTitle(
	'section_title_4',
	esc_html__( 'Slide Content Animations Controlled by Scrolling', 'hudson' )
);
$edgtSlideBehaviour->addChild(
	'section_title_4',
	$section_title_4
);

$edgt_slide_general_animation = new HudsonEdgeMetaField(
	"yesno",
	"edgt_slide_general_animation",
	"no",
	esc_html__( "Animate Whole Slide Content Group at Once on Scroll", 'hudson' ),
	esc_html__( "All parts of slide content will animate on scroll as group", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_edgt_slide_general_animation_container"
	)
);
$edgtSlideBehaviour->addChild(
	'edgt_slide_general_animation',
	$edgt_slide_general_animation
);

$edgt_slide_general_animation_container = new HudsonEdgeContainer(
	'edgt_slide_general_animation_container',
	'edgt_slide_general_animation',
	'no'
);
$edgtSlideBehaviour->addChild(
	'edgt_slide_general_animation_container',
	$edgt_slide_general_animation_container
);

$edgt_slide_content_animation_data_start = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation Start Point", 'hudson' ),
	esc_html__( "These are starting properties for the scrolling animation of the slide content group", 'hudson' )
);
$edgt_slide_general_animation_container->addChild(
	"edgt_slide_content_animation_data_start",
	$edgt_slide_content_animation_data_start
);

$row1 = new HudsonEdgeRow();
$edgt_slide_content_animation_data_start->addChild(
	"row1",
	$row1
);

$edgt_slide_data_start = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_start",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' ),
	"",
	array(),
	array( "col_width" => 1 )
);
$row1->addChild(
	"edgt_slide_data_start",
	$edgt_slide_data_start
);

$edgt_slide_data_start_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_start_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' ),
	"",
	array(),
	array( "col_width" => 4 )
);
$row1->addChild(
	"edgt_slide_data_start_custom_style",
	$edgt_slide_data_start_custom_style
);

$edgt_slide_content_animation_data_end = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation End Point", 'hudson' ),
	esc_html__( "These are ending properties for the scrolling animation of the slide content group", 'hudson' )
);
$edgt_slide_general_animation_container->addChild(
	"edgt_slide_content_animation_data_end",
	$edgt_slide_content_animation_data_end
);

$row2 = new HudsonEdgeRow();
$edgt_slide_content_animation_data_end->addChild(
	'row2',
	$row2
);

$edgt_slide_data_end = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_end",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' ),
	""
);
$row2->addChild(
	"edgt_slide_data_end",
	$edgt_slide_data_end
);

$edgt_slide_data_end_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_end_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' ),
	""
);
$row2->addChild(
	"edgt_slide_data_end_custom_style",
	$edgt_slide_data_end_custom_style
);

//Title scroll animation
$edgt_slide_scroll_title_container = new HudsonEdgeContainerNoStyle(
	'edgt_slide_scroll_title_container',
	'edgt_slide-hide-title',
	'yes'
);
$edgtSlideBehaviour->addChild(
	'edgt_slide_scroll_title_container',
	$edgt_slide_scroll_title_container
);

$edgt_slide_title_animation_scroll = new HudsonEdgeMetaField(
	"yesno",
	"edgt_slide_title_animation_scroll",
	"no",
	esc_html__( "Animate Title on Scroll", 'hudson' ),
	esc_html__( "Enable title text to animate separately", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_edgt_slide_title_animation_scroll_container"
	)
);
$edgt_slide_scroll_title_container->addChild(
	'edgt_slide_title_animation_scroll',
	$edgt_slide_title_animation_scroll
);

$edgt_slide_title_animation_scroll_container = new HudsonEdgeContainer(
	'edgt_slide_title_animation_scroll_container',
	'edgt_slide_title_animation_scroll',
	'no'
);
$edgt_slide_scroll_title_container->addChild(
	'edgt_slide_title_animation_scroll_container',
	$edgt_slide_title_animation_scroll_container
);

$edgt_slide_title_animation_data_start = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation Start Point", 'hudson' ),
	esc_html__( "These are properties for the first keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_title_animation_scroll_container->addChild(
	"edgt_slide_title_animation_data_start",
	$edgt_slide_title_animation_data_start
);

$row1 = new HudsonEdgeRow();
$edgt_slide_title_animation_data_start->addChild(
	"row1",
	$row1
);

$edgt_slide_data_title_start = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_title_start",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' ),
	""
);
$row1->addChild(
	"edgt_slide_data_title_start",
	$edgt_slide_data_title_start
);

$edgt_slide_data_title_start_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_title_start_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' ),
	""
);
$row1->addChild(
	"edgt_slide_data_title_start_custom_style",
	$edgt_slide_data_title_start_custom_style
);

$edgt_slide_title_animation_data_end = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation End Point", 'hudson' ),
	esc_html__( "These are properties for the last keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_title_animation_scroll_container->addChild(
	"edgt_slide_title_animation_data_end",
	$edgt_slide_title_animation_data_end
);

$row2 = new HudsonEdgeRow();
$edgt_slide_title_animation_data_end->addChild(
	"row2",
	$row2
);

$edgt_slide_data_title_end = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_title_end",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' ),
	""
);
$row2->addChild(
	"edgt_slide_data_title_end",
	$edgt_slide_data_title_end
);

$edgt_slide_data_title_end_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_title_end_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' ),
	""
);
$row2->addChild(
	"edgt_slide_data_title_end_custom_style",
	$edgt_slide_data_title_end_custom_style
);

//Subtitle scroll animation
$edgt_slide_subtitle_animation_scroll = new HudsonEdgeMetaField(
	"yesno",
	"edgt_slide_subtitle_animation_scroll",
	"no",
	esc_html__( "Animate Subtitle on Scroll", 'hudson' ),
	esc_html__( "Enable subtitle text to animate separately", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_edgt_slide_subtitle_animation_scroll_container"
	)
);
$edgtSlideBehaviour->addChild(
	'edgt_slide_subtitle_animation_scroll',
	$edgt_slide_subtitle_animation_scroll
);

$edgt_slide_subtitle_animation_scroll_container = new HudsonEdgeContainer(
	'edgt_slide_subtitle_animation_scroll_container',
	'edgt_slide_subtitle_animation_scroll',
	'no'
);
$edgtSlideBehaviour->addChild(
	'edgt_slide_subtitle_animation_scroll_container',
	$edgt_slide_subtitle_animation_scroll_container
);

$edgt_slide_subtitle_animation_data_start = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation Start Point", 'hudson' ),
	esc_html__( "These are properties for the first keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_subtitle_animation_scroll_container->addChild(
	"edgt_slide_subtitle_animation_data_start",
	$edgt_slide_subtitle_animation_data_start
);

$row1 = new HudsonEdgeRow();
$edgt_slide_subtitle_animation_data_start->addChild(
	"row1",
	$row1
);

$edgt_slide_data_subtitle_start = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_subtitle_start",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' ),
	""
);
$row1->addChild(
	"edgt_slide_data_subtitle_start",
	$edgt_slide_data_subtitle_start
);

$edgt_slide_data_subtitle_start_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_subtitle_start_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' ),
	""
);
$row1->addChild(
	"edgt_slide_data_subtitle_start_custom_style",
	$edgt_slide_data_subtitle_start_custom_style
);

$edgt_slide_subtitle_animation_data_end = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation End Point", 'hudson' ),
	esc_html__( "These are properties for the last keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_subtitle_animation_scroll_container->addChild(
	"edgt_slide_subtitle_animation_data_end",
	$edgt_slide_subtitle_animation_data_end
);

$row2 = new HudsonEdgeRow();
$edgt_slide_subtitle_animation_data_end->addChild(
	"row2",
	$row2
);

$edgt_slide_data_subtitle_end = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_subtitle_end",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' ),
	""
);
$row2->addChild(
	"edgt_slide_data_subtitle_end",
	$edgt_slide_data_subtitle_end
);

$edgt_slide_data_subtitle_end_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_subtitle_end_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' ),
	""
);
$row2->addChild(
	"edgt_slide_data_subtitle_end_custom_style",
	$edgt_slide_data_subtitle_end_custom_style
);

//Graphics scroll animation
$edgt_slide_graphic_animation_scroll = new HudsonEdgeMetaField(
	"yesno",
	"edgt_slide_graphic_animation_scroll",
	"no",
	esc_html__( "Animate Graphic on Scroll", 'hudson' ),
	esc_html__( "Enable graphic to animate separately", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_edgt_slide_graphic_animation_scroll_container"
	)
);
$edgtSlideBehaviour->addChild(
	'edgt_slide_graphic_animation_scroll',
	$edgt_slide_graphic_animation_scroll
);

$edgt_slide_graphic_animation_scroll_container = new HudsonEdgeContainer(
	'edgt_slide_graphic_animation_scroll_container',
	'edgt_slide_graphic_animation_scroll',
	'no'
);
$edgtSlideBehaviour->addChild(
	'edgt_slide_graphic_animation_scroll_container',
	$edgt_slide_graphic_animation_scroll_container
);

$edgt_slide_graphics_animation_data_start = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation Start Point", 'hudson' ),
	esc_html__( "These are properties for the first keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_graphic_animation_scroll_container->addChild(
	"edgt_slide_graphics_animation_data_start",
	$edgt_slide_graphics_animation_data_start
);

$row1 = new HudsonEdgeRow();
$edgt_slide_graphics_animation_data_start->addChild(
	"row1",
	$row1
);

$edgt_slide_data_graphics_start = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_graphics_start",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' ),
	""
);
$row1->addChild(
	"edgt_slide_data_graphics_start",
	$edgt_slide_data_graphics_start
);

$edgt_slide_data_graphics_start_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_graphics_start_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' ),
	""
);
$row1->addChild(
	"edgt_slide_data_graphics_start_custom_style",
	$edgt_slide_data_graphics_start_custom_style
);

$edgt_slide_graphics_animation_data_end = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation End Point", 'hudson' ),
	esc_html__( "These are properties for the last keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_graphic_animation_scroll_container->addChild(
	"edgt_slide_graphics_animation_data_end",
	$edgt_slide_graphics_animation_data_end
);

$row2 = new HudsonEdgeRow();
$edgt_slide_graphics_animation_data_end->addChild(
	"row2",
	$row2
);

$edgt_slide_data_graphics_end = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_graphics_end",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' ),
	""
);
$row2->addChild(
	"edgt_slide_data_graphics_end",
	$edgt_slide_data_graphics_end
);

$edgt_slide_data_graphics_end_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_graphics_end_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' ),
	""
);
$row2->addChild(
	"edgt_slide_data_graphics_end_custom_style",
	$edgt_slide_data_graphics_end_custom_style
);

//Text scroll animation
$edgt_slide_text_animation_scroll = new HudsonEdgeMetaField(
	"yesno",
	"edgt_slide_text_animation_scroll",
	"no",
	esc_html__( "Animate Text on Scroll", 'hudson' ),
	esc_html__( "Enable text to animate separately", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_edgt_slide_text_animation_scroll_container"
	)
);
$edgtSlideBehaviour->addChild(
	'edgt_slide_text_animation_scroll',
	$edgt_slide_text_animation_scroll
);

$edgt_slide_text_animation_scroll_container = new HudsonEdgeContainer(
	'edgt_slide_text_animation_scroll_container',
	'edgt_slide_text_animation_scroll',
	'no'
);
$edgtSlideBehaviour->addChild(
	'edgt_slide_text_animation_scroll_container',
	$edgt_slide_text_animation_scroll_container
);

$edgt_slide_text_animation_data_start = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation Start Point", 'hudson' ),
	esc_html__( "These are properties for the first keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_text_animation_scroll_container->addChild(
	"edgt_slide_text_animation_data_start",
	$edgt_slide_text_animation_data_start
);

$row1 = new HudsonEdgeRow();
$edgt_slide_text_animation_data_start->addChild(
	"row1",
	$row1
);

$edgt_slide_data_text_start = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_text_start",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' ),
	""
);
$row1->addChild(
	"edgt_slide_data_text_start",
	$edgt_slide_data_text_start
);

$edgt_slide_data_text_start_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_text_start_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' ),
	""
);
$row1->addChild(
	"edgt_slide_data_text_start_custom_style",
	$edgt_slide_data_text_start_custom_style
);

$edgt_slide_text_animation_data_end = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation End Point", 'hudson' ),
	esc_html__( "These are properties for the last keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_text_animation_scroll_container->addChild(
	"edgt_slide_text_animation_data_end",
	$edgt_slide_text_animation_data_end
);

$row2 = new HudsonEdgeRow();
$edgt_slide_text_animation_data_end->addChild(
	"row2",
	$row2
);

$edgt_slide_data_text_end = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_text_end",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' ),
	""
);
$row2->addChild(
	"edgt_slide_data_text_end",
	$edgt_slide_data_text_end
);

$edgt_slide_data_text_end_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_text_end_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' ),
	""
);
$row2->addChild(
	"edgt_slide_data_text_end_custom_style",
	$edgt_slide_data_text_end_custom_style
);

//Button 1 scroll animation
$edgt_slide_button1_animation_scroll = new HudsonEdgeMetaField(
	"yesno",
	"edgt_slide_button1_animation_scroll",
	"no",
	esc_html__( "Animate Button 1 on Scroll", 'hudson' ),
	esc_html__( "Enable button 1 to animate separately", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_edgt_slide_button1_animation_scroll_container"
	)
);
$edgtSlideBehaviour->addChild(
	'edgt_slide_button1_animation_scroll',
	$edgt_slide_button1_animation_scroll
);

$edgt_slide_button1_animation_scroll_container = new HudsonEdgeContainer(
	'edgt_slide_button1_animation_scroll_container',
	'edgt_slide_button1_animation_scroll',
	'no'
);
$edgtSlideBehaviour->addChild(
	'edgt_slide_button1_animation_scroll_container',
	$edgt_slide_button1_animation_scroll_container
);

$edgt_slide_button_1_animation_data_start = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation Start Point", 'hudson' ),
	esc_html__( "These are properties for the first keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_button1_animation_scroll_container->addChild(
	"edgt_slide_button_1_animation_data_start",
	$edgt_slide_button_1_animation_data_start
);

$row1 = new HudsonEdgeRow();
$edgt_slide_button_1_animation_data_start->addChild(
	"row1",
	$row1
);

$edgt_slide_data_button_1_start = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_button_1_start",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' )
);
$row1->addChild(
	"edgt_slide_data_button_1_start",
	$edgt_slide_data_button_1_start
);

$edgt_slide_data_button_1_start_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_button_1_start_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' )
);
$row1->addChild(
	"edgt_slide_data_button_1_start_custom_style",
	$edgt_slide_data_button_1_start_custom_style
);

$edgt_slide_button_1_animation_data_end = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation End Point", 'hudson' ),
	esc_html__( "These are properties for the last keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_button1_animation_scroll_container->addChild(
	"edgt_slide_button_1_animation_data_end",
	$edgt_slide_button_1_animation_data_end
);

$row2 = new HudsonEdgeRow();
$edgt_slide_button_1_animation_data_end->addChild(
	"row2",
	$row2
);

$edgt_slide_data_button_1_end = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_button_1_end",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' )
);
$row2->addChild(
	"edgt_slide_data_button_1_end",
	$edgt_slide_data_button_1_end
);

$edgt_slide_data_button_1_end_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_button_1_end_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' )
);
$row2->addChild(
	"edgt_slide_data_button_1_end_custom_style",
	$edgt_slide_data_button_1_end_custom_style
);

//Button 2 scroll animation
$edgt_slide_button2_animation_scroll = new HudsonEdgeMetaField(
	"yesno",
	"edgt_slide_button2_animation_scroll",
	"no",
	esc_html__( "Animate Button 2 on Scroll", 'hudson' ),
	esc_html__( "Enable button 2 to animate separately", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_edgt_slide_button2_animation_scroll_container"
	)
);
$edgtSlideBehaviour->addChild(
	'edgt_slide_button2_animation_scroll',
	$edgt_slide_button2_animation_scroll
);

$edgt_slide_button2_animation_scroll_container = new HudsonEdgeContainer(
	'edgt_slide_button2_animation_scroll_container',
	'edgt_slide_button2_animation_scroll',
	'no'
);
$edgtSlideBehaviour->addChild(
	'edgt_slide_button2_animation_scroll_container',
	$edgt_slide_button2_animation_scroll_container
);

$edgt_slide_button_2_animation_data_start = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation Start Point", 'hudson' ),
	esc_html__( "These are properties for the first keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_button2_animation_scroll_container->addChild(
	"edgt_slide_button_2_animation_data_start",
	$edgt_slide_button_2_animation_data_start
);

$row1 = new HudsonEdgeRow();
$edgt_slide_button_2_animation_data_start->addChild(
	"row1",
	$row1
);

$edgt_slide_data_button_2_start = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_button_2_start",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' )
);
$row1->addChild(
	"edgt_slide_data_button_2_start",
	$edgt_slide_data_button_2_start
);

$edgt_slide_data_button_2_start_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_button_2_start_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' )
);
$row1->addChild(
	"edgt_slide_data_button_2_start_custom_style",
	$edgt_slide_data_button_2_start_custom_style
);

$edgt_slide_button_2_animation_data_end = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation End Point", 'hudson' ),
	esc_html__( "These are properties for the last keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_button2_animation_scroll_container->addChild(
	"edgt_slide_button_2_animation_data_end",
	$edgt_slide_button_2_animation_data_end
);

$row2 = new HudsonEdgeRow();
$edgt_slide_button_2_animation_data_end->addChild(
	"row2",
	$row2
);

$edgt_slide_data_button_2_end = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_button_2_end",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' )
);
$row2->addChild(
	"edgt_slide_data_button_2_end",
	$edgt_slide_data_button_2_end
);

$edgt_slide_data_button_2_end_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_button_2_end_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' )
);
$row2->addChild(
	"edgt_slide_data_button_2_end_custom_style",
	$edgt_slide_data_button_2_end_custom_style
);

$edgt_slide_scroll_separator_container = new HudsonEdgeContainerNoStyle(
	'edgt_slide_scroll_separator_container',
	'edgt_slide-separator-title',
	'no'
);
$edgtSlideBehaviour->addChild(
	'edgt_slide_scroll_separator_container',
	$edgt_slide_scroll_separator_container
);

//Separator Top scroll animation
$edgt_slide_separator_top_animation_scroll = new HudsonEdgeMetaField(
	"yesno",
	"edgt_slide_separator_top_animation_scroll",
	"no",
	esc_html__( "Animate Separator Top on Scroll", 'hudson' ),
	esc_html__( "Enable separator top to animate separately", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_edgt_slide_separator_top_animation_scroll_container"
	)
);
$edgt_slide_scroll_separator_container->addChild(
	'edgt_slide_separator_top_animation_scroll',
	$edgt_slide_separator_top_animation_scroll
);

$edgt_slide_separator_top_animation_scroll_container = new HudsonEdgeContainer(
	'edgt_slide_separator_top_animation_scroll_container',
	'edgt_slide_separator_top_animation_scroll',
	'no'
);
$edgt_slide_scroll_separator_container->addChild(
	'edgt_slide_separator_top_animation_scroll_container',
	$edgt_slide_separator_top_animation_scroll_container
);

$edgt_slide_separator_top_animation_data_start = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation Start Point", 'hudson' ),
	esc_html__( "These are properties for the first keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_separator_top_animation_scroll_container->addChild(
	"edgt_slide_separator_top_animation_data_start",
	$edgt_slide_separator_top_animation_data_start
);

$row1 = new HudsonEdgeRow();
$edgt_slide_separator_top_animation_data_start->addChild(
	"row1",
	$row1
);

$edgt_slide_data_separator_top_start = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_separator_top_start",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' )
);
$row1->addChild(
	"edgt_slide_data_separator_top_start",
	$edgt_slide_data_separator_top_start
);

$edgt_slide_data_separator_top_start_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_separator_top_start_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' )
);
$row1->addChild(
	"edgt_slide_data_separator_top_start_custom_style",
	$edgt_slide_data_separator_top_start_custom_style
);

$edgt_slide_separator_top_animation_data_end = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation End Point", 'hudson' ),
	esc_html__( "These are properties for the last keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_separator_top_animation_scroll_container->addChild(
	"edgt_slide_separator_top_animation_data_end",
	$edgt_slide_separator_top_animation_data_end
);

$row2 = new HudsonEdgeRow();
$edgt_slide_separator_top_animation_data_end->addChild(
	"row2",
	$row2
);

$edgt_slide_data_separator_top_end = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_separator_top_end",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' )
);
$row2->addChild(
	"edgt_slide_data_separator_top_end",
	$edgt_slide_data_separator_top_end
);

$edgt_slide_data_separator_top_end_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_separator_top_end_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' )
);
$row2->addChild(
	"edgt_slide_data_separator_top_end_custom_style",
	$edgt_slide_data_separator_top_end_custom_style
);

//Separator Bottom scroll animation
$edgt_slide_separator_bottom_animation_scroll = new HudsonEdgeMetaField(
	"yesno",
	"edgt_slide_separator_bottom_animation_scroll",
	"no",
	esc_html__( "Animate Separator Bottom on Scroll", 'hudson' ),
	esc_html__( "Enable separator bottom to animate separately", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_edgt_slide_separator_bottom_animation_scroll_container"
	)
);
$edgt_slide_scroll_separator_container->addChild(
	'edgt_slide_separator_bottom_animation_scroll',
	$edgt_slide_separator_bottom_animation_scroll
);

$edgt_slide_separator_bottom_animation_scroll_container = new HudsonEdgeContainer(
	'edgt_slide_separator_bottom_animation_scroll_container',
	'edgt_slide_separator_bottom_animation_scroll',
	'no'
);
$edgt_slide_scroll_separator_container->addChild(
	'edgt_slide_separator_bottom_animation_scroll_container',
	$edgt_slide_separator_bottom_animation_scroll_container
);

$edgt_slide_separator_bottom_animation_data_start = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation Start Point", 'hudson' ),
	esc_html__( "These are properties for the first keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_separator_bottom_animation_scroll_container->addChild(
	"edgt_slide_separator_bottom_animation_data_start",
	$edgt_slide_separator_bottom_animation_data_start
);

$row1 = new HudsonEdgeRow();
$edgt_slide_separator_bottom_animation_data_start->addChild(
	"row1",
	$row1
);

$edgt_slide_data_separator_bottom_start = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_separator_bottom_start",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' )
);
$row1->addChild(
	"edgt_slide_data_separator_bottom_start",
	$edgt_slide_data_separator_bottom_start
);

$edgt_slide_data_separator_bottom_start_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_separator_bottom_start_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' )
);
$row1->addChild(
	"edgt_slide_data_separator_bottom_start_custom_style",
	$edgt_slide_data_separator_bottom_start_custom_style
);

$edgt_slide_separator_bottom_animation_data_end = new HudsonEdgeGroup(
	esc_html__( "Scrolling Animation End Point", 'hudson' ),
	esc_html__( "These are properties for the last keyframe in scrolling animation", 'hudson' )
);
$edgt_slide_separator_bottom_animation_scroll_container->addChild(
	"edgt_slide_separator_bottom_animation_data_end",
	$edgt_slide_separator_bottom_animation_data_end
);

$row2 = new HudsonEdgeRow();
$edgt_slide_separator_bottom_animation_data_end->addChild(
	"row2",
	$row2
);

$edgt_slide_data_separator_bottom_end = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_data_separator_bottom_end",
	"",
	esc_html__( "Scrollbar Top Distance (px)", 'hudson' )
);
$row2->addChild(
	"edgt_slide_data_separator_bottom_end",
	$edgt_slide_data_separator_bottom_end
);

$edgt_slide_data_separator_bottom_end_custom_style = new HudsonEdgeMetaField(
	"textareasimple",
	"edgt_slide_data_separator_bottom_end_custom_style",
	"",
	esc_html__( "Enter CSS declarations separated by semicolons", 'hudson' )
);
$row2->addChild(
	"edgt_slide_data_separator_bottom_end_custom_style",
	$edgt_slide_data_separator_bottom_end_custom_style
);

//Slide Title

$edgtSlideTitle = new HudsonEdgeMetaBox(
	"slides",
	esc_html__( "Slide Title Style", 'hudson' ),
	"edgt_slide-hide-title",
	array( "yes" )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"slides_title",
	$edgtSlideTitle
);

$title_text_group = new HudsonEdgeGroup(
	esc_html__( "Title Text Style", 'hudson' ),
	esc_html__( "Define styles for title text", 'hudson' )
);
$edgtSlideTitle->addChild(
	"title_text_group",
	$title_text_group
);
$row1 = new HudsonEdgeRow();
$title_text_group->addChild(
	"row1",
	$row1
);
$title_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-title-color",
	"",
	esc_html__( "Font Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-title-color",
	$title_color
);
$title_fontsize = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-title-font-size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-title-font-size",
	$title_fontsize
);
$title_lineheight = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-title-line-height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-title-line-height",
	$title_lineheight
);
$title_letterspacing = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-title-letter-spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-title-letter-spacing",
	$title_letterspacing
);

$row2 = new HudsonEdgeRow( true );
$title_text_group->addChild(
	"row2",
	$row2
);
$title_google_fonts = new HudsonEdgeMetaField(
	"fontsimple",
	"edgt_slide-title-font-family",
	"",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"edgt_slide-title-font-family",
	$title_google_fonts
);
$title_fontstyle = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-title-font-style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"edgt_slide-title-font-style",
	$title_fontstyle
);
$title_fontweight = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-title-font-weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"edgt_slide-title-font-weight",
	$title_fontweight
);
$title_texttransform = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-title-text-transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"edgt_slide-title-text-transform",
	$title_texttransform
);

$title_background_group = new HudsonEdgeGroup(
	esc_html__( "Background", 'hudson' ),
	esc_html__( "Define background for title", 'hudson' )
);
$edgtSlideTitle->addChild(
	"title_background_group",
	$title_background_group
);
$row1 = new HudsonEdgeRow();
$title_background_group->addChild(
	"row1",
	$row1
);
$title_background_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-title-background-color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-title-background-color",
	$title_background_color
);
$title_background_color_transparency = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-title-bg-color-transparency",
	"",
	esc_html__( "Background Color Transparency (values 0-1)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-title-bg-color-transparency",
	$title_background_color_transparency
);

$title_margin_group = new HudsonEdgeGroup(
	esc_html__( "Margin Bottom (px)", 'hudson' ),
	esc_html__( "Enter value for title bottom margin (default value is 14)", 'hudson' )
);
$edgtSlideTitle->addChild(
	"title_margin_group",
	$title_margin_group
);
$row1 = new HudsonEdgeRow();
$title_margin_group->addChild(
	"row1",
	$row1
);
$title_margin_bottom = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_title_margin_bottom",
	"",
	"",
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_title_margin_bottom",
	$title_margin_bottom
);

$title_padding_group = new HudsonEdgeGroup(
	esc_html__( "Padding", 'hudson' ),
	esc_html__( "Define padding for title", 'hudson' )
);
$edgtSlideTitle->addChild(
	"title_padding_group",
	$title_padding_group
);
$row1 = new HudsonEdgeRow();
$title_padding_group->addChild(
	"row1",
	$row1
);
$title_padding_top = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_title_padding_top",
	"",
	esc_html__( "Top Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_title_padding_top",
	$title_padding_top
);
$title_padding_right = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_title_padding_right",
	"",
	esc_html__( "Right Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_title_padding_right",
	$title_padding_right
);
$title_padding_bottom = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_title_padding_bottom",
	"",
	esc_html__( "Bottom Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_title_padding_bottom",
	$title_padding_bottom
);
$title_padding_left = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_title_padding_left",
	"",
	esc_html__( "Left Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_title_padding_left",
	$title_padding_left
);

$edgt_slide_title_border = new HudsonEdgeMetaField(
	'yesno',
	'edgt_slide_title_border',
	'no',
	esc_html__( 'Border', 'hudson' ),
	esc_html__( 'Do you want to have a title border?', 'hudson' ),
	array(),
	array(
		'dependence'             => true,
		'dependence_hide_on_yes' => '',
		'dependence_show_on_yes' => '#edgtf_title_border_container'
	)
);
$edgtSlideTitle->addChild(
	'edgt_slide_title_border',
	$edgt_slide_title_border
);

$title_border_container = new HudsonEdgeContainer(
	'title_border_container',
	'edgt_slide_title_border',
	'no'
);
$edgtSlideTitle->addChild(
	'title_border_container',
	$title_border_container
);

$title_border_group = new HudsonEdgeGroup(
	esc_html__( "Title Border", 'hudson' ),
	esc_html__( "Define border for title", 'hudson' )
);
$title_border_container->addChild(
	"title_border_group",
	$title_border_group
);
$row1 = new HudsonEdgeRow();
$title_border_group->addChild(
	"row1",
	$row1
);
$title_border_thickness = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_title_border_thickness",
	"",
	esc_html__( "Thickness (px)", 'hudson' ),
	""
);
$row1->addChild(
	"title_border_thickness",
	$title_border_thickness
);
$title_border_style = new HudsonEdgeMetaField(
	"selectsimple",
	"edgt_slide_title_border_style",
	"",
	esc_html__( "Style", 'hudson' ),
	"",
	array(
		"solid" => esc_html__( "solid", 'hudson' ),
		"dashed" => esc_html__( "dashed", 'hudson' ),
		"dotted" => esc_html__( "dotted", 'hudson' ),
		"double" => esc_html__( "double", 'hudson' ),
		"groove" => esc_html__( "groove", 'hudson' ),
		"ridge" => esc_html__( "ridge", 'hudson' ),
		"inset" => esc_html__( "inset", 'hudson' ),
		"outset" => esc_html__( "outset", 'hudson' )
	)
);
$row1->addChild(
	"title_border_style",
	$title_border_style
);
$title_border_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slider_title_border_color",
	"",
	esc_html__( "Color", 'hudson' ),
	""
);
$row1->addChild(
	"edgt_slider_title_border_color",
	$title_border_color
);

$edgt_slide_title_separator = new HudsonEdgeMetaField(
	"yesno",
	"edgt_slide-separator-title",
	"no",
	esc_html__( "Title Separator", 'hudson' ),
	esc_html__( "Do you want to have a title separator?", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "",
		"dependence_show_on_yes" => "#edgtf_edgt_slide_title_separator_container, #edgtf_edgt_slide_scroll_separator_container"
	)
);
$edgtSlideTitle->addChild(
	"edgt_slide-separator-title",
	$edgt_slide_title_separator
);

$edgt_slide_title_separator_container = new HudsonEdgeContainer(
	"edgt_slide_title_separator_container",
	"edgt_slide-separator-title",
	"no"
);
$edgtSlideTitle->addChild(
	"edgt_slide_title_separator_container",
	$edgt_slide_title_separator_container
);

//Separator with or without icon
$edgt_slide_title_separator_type = new HudsonEdgeMetaField(
	'select',
	'edgt_slide_title_separator_type',
	'',
	esc_html__( 'Separator Type', 'hudson' ),
	'',
	array(
		'without_icon' => esc_html__( 'Without Icon', 'hudson' ),
		'with_icon' => esc_html__( 'With Icon', 'hudson' ),
		'with_custom_icon' => esc_html__( 'With Custom Icon', 'hudson' )
	),
	array(
		'dependence' => true,
		'hide'       => array(
			'without_icon'     => '#edgtf_edgt_slide_title_separator_with_icon_container, #edgtf_edgt_slide_title_separator_with_custom_icon_container',
			'with_icon'        => '#edgtf_edgt_slide_title_separator_without_icon_container, #edgtf_edgt_slide_title_separator_with_custom_icon_container',
			'with_custom_icon' => '#edgtf_edgt_slide_title_separator_with_icon_container, #edgtf_edgt_slide_title_separator_without_icon_container'
		),
		'show'       => array(
			'without_icon'     => '#edgtf_edgt_slide_title_separator_without_icon_container',
			'with_icon'        => '#edgtf_edgt_slide_title_separator_with_icon_container',
			'with_custom_icon' => '#edgtf_edgt_slide_title_separator_with_custom_icon_container'
		)
	)
);
$edgt_slide_title_separator_container->addChild(
	'edgt_slide_title_separator_type',
	$edgt_slide_title_separator_type
);

//Separator without Icon Container
$edgt_slide_title_separator_without_icon_container = new HudsonEdgeContainer(
	'edgt_slide_title_separator_without_icon_container',
	'edgt_slide_title_separator_type',
	'',
	array( 'with_icon', 'with_custom_icon' )
);
$edgt_slide_title_separator_container->addChild(
	'edgt_slide_title_separator_without_icon_container',
	$edgt_slide_title_separator_without_icon_container
);

$edgt_slide_title_separator_align_container = new HudsonEdgeContainerNoStyle(
	'edgt_slide_title_separator_align_container',
	'edgt_slide-title-separator-position',
	'left_right'
);
$edgt_slide_title_separator_without_icon_container->addChild(
	'edgt_slide_title_separator_align_container',
	$edgt_slide_title_separator_align_container
);

$edgt_slide_title_separator_align = new HudsonEdgeMetaField(
	"select",
	"edgt_slide-title-separator-align",
	"both",
	esc_html__( "Alignment", 'hudson' ),
	esc_html__( "Choose alignment of slider separator", 'hudson' ),
	array(
		"none" => esc_html__( "Center", 'hudson' ),
		"left" => esc_html__( "Left", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$edgt_slide_title_separator_align_container->addChild(
	"edgt_slide-title-separator-align",
	$edgt_slide_title_separator_align
);

$edgt_slide_separator_color_group = new HudsonEdgeGroup(
	esc_html__( "Separator Color", 'hudson' ),
	esc_html__( "Define color for slider separator", 'hudson' )
);
$edgt_slide_title_separator_without_icon_container->addChild(
	"edgt_slide_separator_color_group",
	$edgt_slide_separator_color_group
);

$row1 = new HudsonEdgeRow();
$edgt_slide_separator_color_group->addChild(
	"row1",
	$row1
);

$edgt_slide_title_separator_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-separator-color",
	"",
	esc_html__( "Separator Color", 'hudson' ),
	esc_html__( "Choose a color for the separator", 'hudson' )
);
$row1->addChild(
	"edgt_slide-separator-color",
	$edgt_slide_title_separator_color
);

$edgt_slide_title_separator_transparency = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-separator-transparency",
	"",
	esc_html__( "Separator transparency (values 0-1)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-separator-transparency",
	$edgt_slide_title_separator_transparency
);

$edgt_slide_separator_border_group = new HudsonEdgeGroup(
	esc_html__( "Separator Border", 'hudson' ),
	esc_html__( "Define border for slider separator", 'hudson' )
);
$edgt_slide_title_separator_without_icon_container->addChild(
	"edgt_slide_separator_border_group",
	$edgt_slide_separator_border_group
);

$row1 = new HudsonEdgeRow();
$edgt_slide_separator_border_group->addChild(
	"row1",
	$row1
);

$edgt_slide_separator_border_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-separator-border-color",
	"",
	esc_html__( "Color", 'hudson' ),
	esc_html__( "Choose a color for the separator", 'hudson' )
);
$row1->addChild(
	"edgt_slide-separator-border-color",
	$edgt_slide_separator_border_color
);

$edgt_slide_separator_border_width = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-separator-border-width",
	"",
	esc_html__( "Thickness (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-separator-border-width",
	$edgt_slide_separator_border_width
);

$edgt_slide_separator_border_style = new HudsonEdgeMetaField(
	'selectsimple',
	'edgt_slide-separator-border-style',
	'solid',
	esc_html__( 'Style', 'hudson' ),
	'',
	array(
		"solid" => esc_html__( "Solid", 'hudson' ),
		"dashed" => esc_html__( "Dashed", 'hudson' ),
		"dotted" => esc_html__( "Dotted", 'hudson' ),
		"transparent" => esc_html__( "Transparent", 'hudson' )
	)
);
$row1->addChild(
	"edgt_slide-separator-border-style",
	$edgt_slide_separator_border_style
);

$edgt_slide_separator_size_group = new HudsonEdgeGroup(
	esc_html__( "Separator Size", 'hudson' ),
	esc_html__( "Define size for slider separator", 'hudson' )
);
$edgt_slide_title_separator_without_icon_container->addChild(
	"edgt_slide_separator_size_group",
	$edgt_slide_separator_size_group
);

$row1 = new HudsonEdgeRow();
$edgt_slide_separator_size_group->addChild(
	"row1",
	$row1
);

$edgt_slide_title_separator_width = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-separator-width",
	"",
	esc_html__( "Separator Width (%)", 'hudson' ),
	esc_html__( "Enter value from 0% to 100%. Enter just number.", 'hudson' )
);
$row1->addChild(
	"edgt_slide-separator-width",
	$edgt_slide_title_separator_width
);

$edgt_slide_title_separator_thickness = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-separator-thickness",
	"",
	esc_html__( "Separator Thickness (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-separator-thickness",
	$edgt_slide_title_separator_thickness
);

//Separator with icon container
$edgt_slide_title_separator_with_icon_container = new HudsonEdgeContainer(
	'edgt_slide_title_separator_with_icon_container',
	'edgt_slide_title_separator_type',
	'',
	array( 'without_icon', 'with_custom_icon' )
);
$edgt_slide_title_separator_container->addChild(
	'edgt_slide_title_separator_with_icon_container',
	$edgt_slide_title_separator_with_icon_container
);

$edgt_slide_separator_icon_hide_array = array();
$edgt_slide_separator_icon_show_array = array();

if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	
	$edgt_slide_separator_icon_collections_params = $hudson_edge_icon_collections->getIconCollectionsParams();
	
	foreach ( $hudson_edge_icon_collections->iconCollections as $dep_collection_key => $dep_collection_object ) {
		$edgt_slide_separator_icon_hide_array[ $dep_collection_key ] = '';
		
		$edgt_slide_separator_icon_show_array[ $dep_collection_key ] = '#edgtf_edgt_slide_title_separator_with_icon_' . $dep_collection_object->param . '_container';
		
		foreach ( $edgt_slide_separator_icon_collections_params as $edgt_slide_separator_icon_collections_param ) {
			
			if ( $edgt_slide_separator_icon_collections_param !== $dep_collection_object->param ) {
				$edgt_slide_separator_icon_hide_array[ $dep_collection_key ] .= '#edgtf_edgt_slide_title_separator_with_icon_' . $edgt_slide_separator_icon_collections_param . '_container,';
			}
			
		}
		
		$edgt_slide_separator_icon_hide_array[ $dep_collection_key ] = rtrim(
			$edgt_slide_separator_icon_hide_array[ $dep_collection_key ],
			','
		);
	}
	
}

$edgt_slide_title_separator_with_icon_icon_pack = new HudsonEdgeMetaField(
	'select',
	'edgt_slide_title_separator_with_icon_icon_pack',
	'font_awesome',
	esc_html__( 'Icon Package', 'hudson' ),
	esc_html__( 'Choose Icon Package', 'hudson' ),
	$hudson_edge_icon_collections->getIconCollections(),
	array(
		'dependence' => true,
		'hide'       => $edgt_slide_separator_icon_hide_array,
		'show'       => $edgt_slide_separator_icon_show_array
	)
);
$edgt_slide_title_separator_with_icon_container->addChild(
	'edgt_slide_title_separator_with_icon_icon_pack',
	$edgt_slide_title_separator_with_icon_icon_pack
);

if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	
	foreach ( $hudson_edge_icon_collections->iconCollections as $collection_key => $collection_object ) {
		$icons_array = $collection_object->getIconsArray();
		
		$icon_collections_keys = $hudson_edge_icon_collections->getIconCollectionsKeys();
		
		unset(
			$icon_collections_keys[ array_search(
				$collection_key,
				$icon_collections_keys
			) ]
		);
		
		$edgt_slide_title_separator_icon_hide_values = $icon_collections_keys;
		
		$edgt_slide_title_separator_with_icon_icon_pack_container = new HudsonEdgeContainer(
			'edgt_slide_title_separator_with_icon_' . $collection_object->param . '_container',
			'edgt_slide_title_separator_with_icon_icon_pack',
			'',
			$edgt_slide_title_separator_icon_hide_values
		);
		$edgt_slide_title_separator_with_icon_container->addChild(
			'edgt_slide_title_separator_with_icon_' . $collection_object->param . '_container',
			$edgt_slide_title_separator_with_icon_icon_pack_container
		);
		
		$edgt_slide_title_separator_with_icon_icon_type = new HudsonEdgeMetaField(
			'select',
			'edgt_slide_title_separator_with_icon_' . $collection_object->param,
			'',
			$collection_object->title,
			esc_html__( 'Icon Package', 'hudson' ),
			$icons_array
		);
		$edgt_slide_title_separator_with_icon_icon_pack_container->addChild(
			'edgt_slide_title_separator_with_icon_' . $collection_object->param,
			$edgt_slide_title_separator_with_icon_icon_type
		);
		
	}
	
}

$edgt_slide_title_separator_with_icon_separator_size_group = new HudsonEdgeGroup(
	esc_html__( 'Separator Size and Style', 'hudson' ),
	esc_html__( 'Define size, color and margins', 'hudson' )
);
$edgt_slide_title_separator_with_icon_container->addChild(
	'edgt_slide_title_separator_with_icon_separator_size_group',
	$edgt_slide_title_separator_with_icon_separator_size_group
);

$row1 = new HudsonEdgeRow();
$edgt_slide_title_separator_with_icon_separator_size_group->addChild(
	'row1',
	$row1
);

$edgt_slide_title_separator_with_icon_line_style = new HudsonEdgeMetaField(
	'selectsimple',
	'edgt_slide_title_separator_with_icon_line_style',
	'normal',
	esc_html__( 'Separator Line Style', 'hudson' ),
	'',
	array(
		"solid" => esc_html__( "Solid", 'hudson' ),
		"dashed" => esc_html__( "Dashed", 'hudson' ),
		"dotted" => esc_html__( "Dotted", 'hudson' ),
		"transparent" => esc_html__( "Transparent", 'hudson' )
	)
);
$row1->addChild(
	'edgt_slide_title_separator_with_icon_line_style',
	$edgt_slide_title_separator_with_icon_line_style
);

$edgt_slide_title_separator_with_icon_separator_width = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_title_separator_with_icon_separator_width',
	'',
	esc_html__( 'Width (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_slide_title_separator_with_icon_separator_width',
	$edgt_slide_title_separator_with_icon_separator_width
);

$edgt_slide_title_separator_with_icon_separator_margin_top = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_title_separator_with_icon_separator_margin_top',
	'',
	esc_html__( 'Top Margin (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_slide_title_separator_with_icon_separator_margin_top',
	$edgt_slide_title_separator_with_icon_separator_margin_top
);

$edgt_slide_title_separator_with_icon_separator_margin_bottom = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_title_separator_with_icon_separator_margin_bottom',
	'',
	esc_html__( 'Bottom Margin (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_slide_title_separator_with_icon_separator_margin_bottom',
	$edgt_slide_title_separator_with_icon_separator_margin_bottom
);

$row2 = new HudsonEdgeRow( true );
$edgt_slide_title_separator_with_icon_separator_size_group->addChild(
	'row2',
	$row2
);

$edgt_slide_title_separator_with_icon_separator_thickness = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_title_separator_with_icon_separator_thickness',
	'',
	esc_html__( 'Thickness (px)', 'hudson' ),
	''
);
$row2->addChild(
	'edgt_slide_title_separator_with_icon_separator_thickness',
	$edgt_slide_title_separator_with_icon_separator_thickness
);

$edgt_slide_title_separator_with_icon_separator_color = new HudsonEdgeMetaField(
	'colorsimple',
	'edgt_slide_title_separator_with_icon_separator_color',
	'',
	esc_html__( 'Separator Color', 'hudson' ),
	''
);
$row2->addChild(
	'edgt_slide_title_separator_with_icon_separator_color',
	$edgt_slide_title_separator_with_icon_separator_color
);

$edgt_slide_title_separator_with_icon_icon_size_group = new HudsonEdgeGroup(
	esc_html__( 'Icon Position and Size', 'hudson' ),
	esc_html__( 'Define icon position, size and type', 'hudson' )
);
$edgt_slide_title_separator_with_icon_container->addChild(
	'edgt_slide_title_separator_with_icon_icon_size_group',
	$edgt_slide_title_separator_with_icon_icon_size_group
);

$row1 = new HudsonEdgeRow();
$edgt_slide_title_separator_with_icon_icon_size_group->addChild(
	'row1',
	$row1
);

$edgt_slide_title_separator_with_icon_icon_type = new HudsonEdgeMetaField(
	'selectsimple',
	'edgt_slide_title_separator_with_icon_icon_type',
	'normal',
	esc_html__( 'Icon Type', 'hudson' ),
	'',
	array(
		'normal' => esc_html__( 'Normal', 'hudson' ),
		'circle' => esc_html__( 'Circle', 'hudson' ),
		'square' => esc_html__( 'Square', 'hudson' )
	)
);
$row1->addChild(
	'edgt_slide_title_separator_with_icon_icon_type',
	$edgt_slide_title_separator_with_icon_icon_type
);

$edgt_slide_title_separator_with_icon_icon_postition = new HudsonEdgeMetaField(
	'selectsimple',
	'edgt_slide_title_separator_with_icon_icon_postition',
	'normal',
	esc_html__( 'Icon Position', 'hudson' ),
	'',
	array(
		'center' => esc_html__( 'Center', 'hudson' ),
		'left' => esc_html__( 'Left', 'hudson' ),
		'right' => esc_html__( 'Right', 'hudson' )
	)
);
$row1->addChild(
	'edgt_slide_title_separator_with_icon_icon_postition',
	$edgt_slide_title_separator_with_icon_icon_postition
);

$edgt_slide_title_separator_with_icon_icon_custom_size = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_title_separator_with_icon_icon_custom_size',
	'',
	esc_html__( 'Icon Custom Size (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_slide_title_separator_with_icon_icon_custom_size',
	$edgt_slide_title_separator_with_icon_icon_custom_size
);

$edgt_slide_title_separator_with_icon_icon_shape_size = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_title_separator_with_icon_icon_shape_size',
	'',
	esc_html__( 'Icon Shape Size (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_slide_title_separator_with_icon_icon_shape_size',
	$edgt_slide_title_separator_with_icon_icon_shape_size
);

$row2 = new HudsonEdgeRow( true );
$edgt_slide_title_separator_with_icon_icon_size_group->addChild(
	'row2',
	$row2
);

$edgt_slide_title_separator_with_icon_icon_margin = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_title_separator_with_icon_icon_margin',
	'',
	esc_html__( 'Icon Margin (px)', 'hudson' ),
	''
);
$row2->addChild(
	'edgt_slide_title_separator_with_icon_icon_margin',
	$edgt_slide_title_separator_with_icon_icon_margin
);

$edgt_slide_title_separator_with_icon_icon_border_radius = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_title_separator_with_icon_icon_border_radius',
	'',
	esc_html__( 'Icon Border Radius (px)', 'hudson' ),
	''
);
$row2->addChild(
	'edgt_slide_title_separator_with_icon_icon_border_radius',
	$edgt_slide_title_separator_with_icon_icon_border_radius
);

$edgt_slide_title_separator_with_icon_icon_border_width = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_title_separator_with_icon_icon_border_width',
	'',
	esc_html__( 'Icon Border Width (px)', 'hudson' ),
	''
);
$row2->addChild(
	'edgt_slide_title_separator_with_icon_icon_border_width',
	$edgt_slide_title_separator_with_icon_icon_border_width
);

$edgt_slide_title_separator_with_icon_icon_colour_group = new HudsonEdgeGroup(
	esc_html__( 'Icon Color', 'hudson' ),
	esc_html__( 'Define icon, icon background and icon hover colors', 'hudson' )
);
$edgt_slide_title_separator_with_icon_container->addChild(
	'edgt_slide_title_separator_with_icon_icon_colour_group',
	$edgt_slide_title_separator_with_icon_icon_colour_group
);

$row3 = new HudsonEdgeRow();
$edgt_slide_title_separator_with_icon_icon_colour_group->addChild(
	'row3',
	$row3
);

$edgt_slide_title_separator_with_icon_icon_color = new HudsonEdgeMetaField(
	'colorsimple',
	'edgt_slide_title_separator_with_icon_icon_color',
	'',
	esc_html__( 'Icon Color', 'hudson' ),
	''
);
$row3->addChild(
	'edgt_slide_title_separator_with_icon_icon_color',
	$edgt_slide_title_separator_with_icon_icon_color
);

$edgt_slide_title_separator_with_icon_icon_border_color = new HudsonEdgeMetaField(
	'colorsimple',
	'edgt_slide_title_separator_with_icon_icon_border_color',
	'',
	esc_html__( 'Icon Border Color', 'hudson' ),
	''
);
$row3->addChild(
	'edgt_slide_title_separator_with_icon_icon_border_color',
	$edgt_slide_title_separator_with_icon_icon_border_color
);

$edgt_slide_title_separator_with_icon_icon_background_color = new HudsonEdgeMetaField(
	'colorsimple',
	'edgt_slide_title_separator_with_icon_icon_background_color',
	'',
	esc_html__( 'Icon Background Color', 'hudson' ),
	''
);
$row3->addChild(
	'edgt_slide_title_separator_with_icon_icon_background_color',
	$edgt_slide_title_separator_with_icon_icon_background_color
);

$edgt_slide_title_separator_with_icon_icon_hover_color = new HudsonEdgeMetaField(
	'colorsimple',
	'edgt_slide_title_separator_with_icon_icon_hover_color',
	'',
	esc_html__( 'Icon Hover Color', 'hudson' ),
	''
);
$row3->addChild(
	'edgt_slide_title_separator_with_icon_icon_hover_color',
	$edgt_slide_title_separator_with_icon_icon_hover_color
);

$row4 = new HudsonEdgeRow( true );
$edgt_slide_title_separator_with_icon_icon_colour_group->addChild(
	'row4',
	$row4
);

$edgt_slide_title_separator_with_icon_icon_hover_border_color = new HudsonEdgeMetaField(
	'colorsimple',
	'edgt_slide_title_separator_with_icon_icon_hover_border_color',
	'',
	esc_html__( 'Icon Hover Border Color', 'hudson' ),
	''
);
$row4->addChild(
	'edgt_slide_title_separator_with_icon_icon_hover_border_color',
	$edgt_slide_title_separator_with_icon_icon_hover_border_color
);

$edgt_slide_title_separator_with_icon_icon_hover_background_color = new HudsonEdgeMetaField(
	'colorsimple',
	'edgt_slide_title_separator_with_icon_icon_hover_background_color',
	'',
	esc_html__( 'Icon Hover Background Color', 'hudson' ),
	''
);
$row4->addChild(
	'edgt_slide_title_separator_with_icon_icon_hover_background_color',
	$edgt_slide_title_separator_with_icon_icon_hover_background_color
);

//Separator with custom icon container
$edgt_slide_title_separator_with_custom_icon_container = new HudsonEdgeContainer(
	'edgt_slide_title_separator_with_custom_icon_container',
	'edgt_slide_title_separator_type',
	'',
	array( 'without_icon', 'with_icon' )
);
$edgt_slide_title_separator_container->addChild(
	'edgt_slide_title_separator_with_custom_icon_container',
	$edgt_slide_title_separator_with_custom_icon_container
);

$edgt_slide_title_separator_with_custom_icon_custom_icon = new HudsonEdgeMetaField(
	'image',
	'edgt_slide_title_separator_with_custom_icon_custom_icon',
	'',
	esc_html__( 'Custom Icon', 'hudson' ),
	''
);
$edgt_slide_title_separator_with_custom_icon_container->addChild(
	'edgt_slide_title_separator_with_custom_icon_custom_icon',
	$edgt_slide_title_separator_with_custom_icon_custom_icon
);

$edgt_slide_title_separator_with_custom_icon_separator_style_group = new HudsonEdgeGroup(
	esc_html__( 'Style', 'hudson' ),
	''
);
$edgt_slide_title_separator_with_custom_icon_container->addChild(
	'edgt_slide_title_separator_with_custom_icon_separator_style_group',
	$edgt_slide_title_separator_with_custom_icon_separator_style_group
);

$row1 = new HudsonEdgeRow();
$edgt_slide_title_separator_with_custom_icon_separator_style_group->addChild(
	'row1',
	$row1
);

$edgt_slide_title_separator_with_custom_icon_line_style = new HudsonEdgeMetaField(
	'selectsimple',
	'edgt_slide_title_separator_with_custom_icon_line_style',
	'normal',
	esc_html__( 'Separator Line Style', 'hudson' ),
	'',
	array(
		"solid" => esc_html__( "Solid", 'hudson' ),
		"dashed" => esc_html__( "Dashed", 'hudson' ),
		"dotted" => esc_html__( "Dotted", 'hudson' ),
		"transparent" => esc_html__( "Transparent", 'hudson' )
	)
);
$row1->addChild(
	'edgt_slide_title_separator_with_custom_icon_line_style',
	$edgt_slide_title_separator_with_custom_icon_line_style
);

$edgt_slide_title_separator_with_custom_icon_separator_width = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_title_separator_with_custom_icon_separator_width',
	'',
	esc_html__( 'Width (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_slide_title_separator_with_custom_icon_separator_width',
	$edgt_slide_title_separator_with_custom_icon_separator_width
);

$edgt_slide_title_separator_with_custom_icon_separator_margin_top = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_title_separator_with_custom_icon_separator_margin_top',
	'',
	esc_html__( 'Top Margin (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_slide_title_separator_with_custom_icon_separator_margin_top',
	$edgt_slide_title_separator_with_custom_icon_separator_margin_top
);

$edgt_slide_title_separator_with_custom_icon_separator_margin_bottom = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_title_separator_with_custom_icon_separator_margin_bottom',
	'',
	esc_html__( 'Bottom Margin (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_slide_title_separator_with_custom_icon_separator_margin_bottom',
	$edgt_slide_title_separator_with_custom_icon_separator_margin_bottom
);

$row2 = new HudsonEdgeRow( true );
$edgt_slide_title_separator_with_custom_icon_separator_style_group->addChild(
	'row2',
	$row2
);

$edgt_slide_title_separator_with_custom_icon_separator_thickness = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_title_separator_with_custom_icon_separator_thickness',
	'',
	esc_html__( 'Thickness (px)', 'hudson' ),
	''
);
$row2->addChild(
	'edgt_slide_title_separator_with_custom_icon_separator_thickness',
	$edgt_slide_title_separator_with_custom_icon_separator_thickness
);

$edgt_slide_title_separator_with_custom_icon_separator_color = new HudsonEdgeMetaField(
	'colorsimple',
	'edgt_slide_title_separator_with_custom_icon_separator_color',
	'',
	esc_html__( 'Separator Color', 'hudson' ),
	''
);
$row2->addChild(
	'edgt_slide_title_separator_with_custom_icon_separator_color',
	$edgt_slide_title_separator_with_custom_icon_separator_color
);

$edgt_slide_title_separator_with_custom_icon_icon_postition = new HudsonEdgeMetaField(
	'selectsimple',
	'edgt_slide_title_separator_with_custom_icon_icon_postition',
	'normal',
	esc_html__( 'Icon Position', 'hudson' ),
	'',
	array(
		'center' => esc_html__( 'Center', 'hudson' ),
		'left' => esc_html__( 'Left', 'hudson' ),
		'right' => esc_html__( 'Right', 'hudson' )
	)
);
$row2->addChild(
	'edgt_slide_title_separator_with_custom_icon_icon_postition',
	$edgt_slide_title_separator_with_custom_icon_icon_postition
);

$edgt_slide_title_separator_with_custom_icon_icon_margin = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_title_separator_with_custom_icon_icon_margin',
	'',
	esc_html__( 'Icon Margin (px)', 'hudson' ),
	''
);
$row2->addChild(
	'edgt_slide_title_separator_with_custom_icon_icon_margin',
	$edgt_slide_title_separator_with_custom_icon_icon_margin
);

//Separator Position Without Icon
$edgt_slide_title_separator_position = new HudsonEdgeMetaField(
	"select",
	"edgt_slide-title-separator-position",
	"both",
	esc_html__( "Position", 'hudson' ),
	esc_html__( "Choose position of slider separator", 'hudson' ),
	array(
		"both" => esc_html__( "Top and Bottom", 'hudson' ),
		"left_right" => esc_html__( "Left and Right", 'hudson' ),
		"top" => esc_html__( "Top", 'hudson' ),
		"bottom" => esc_html__( "Bottom", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			"both"       => "#edgtf_edgt_slide_left_right_separator_container",
			"left_right" => "#edgtf_edgt_slide_top_separator_container, #edgtf_edgt_slide_bottom_separator_container, #edgtf_edgt_slide_title_separator_align_container",
			"top"        => "#edgtf_edgt_slide_bottom_separator_container, #edgtf_edgt_slide_left_right_separator_container",
			"bottom"     => "#edgtf_edgt_slide_top_separator_container, #edgtf_edgt_slide_left_right_separator_container"
		),
		"show"       => array(
			"both"       => "#edgtf_edgt_slide_top_separator_container,#edgtf_edgt_slide_bottom_separator_container, #edgtf_edgt_slide_title_separator_align_container",
			"top"        => "#edgtf_edgt_slide_top_separator_container, #edgtf_edgt_slide_title_separator_align_container",
			"bottom"     => "#edgtf_edgt_slide_bottom_separator_container, #edgtf_edgt_slide_title_separator_align_container",
			"left_right" => "#edgtf_edgt_slide_left_right_separator_container"
		)
	)
);
$edgt_slide_title_separator_without_icon_container->addChild(
	"edgt_slide-title-separator-position",
	$edgt_slide_title_separator_position
);

$edgt_slide_top_separator_container = new HudsonEdgeContainer(
	"edgt_slide_top_separator_container",
	"edgt_slide-title-separator-position",
	"",
	array( "bottom", "left_right" )
);
$edgt_slide_title_separator_without_icon_container->addChild(
	"edgt_slide_top_separator_container",
	$edgt_slide_top_separator_container
);

$group1 = new HudsonEdgeGroup(
	esc_html__( "Top Separator Margins", 'hudson' ),
	esc_html__( "Enter top separator margins", 'hudson' )
);
$edgt_slide_top_separator_container->addChild(
	"group1",
	$group1
);

$row1 = new HudsonEdgeRow();
$group1->addChild(
	"row1",
	$row1
);

$edgt_slide_top_separator_margin_top = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-top-separator-margin-top",
	"",
	esc_html__( "Margin Top (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-top-separator-margin-top",
	$edgt_slide_top_separator_margin_top
);

$edgt_slide_top_separator_margin_bottom = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-top-separator-margin-bottom",
	"",
	esc_html__( "Margin Bottom (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-top-separator-margin-bottom",
	$edgt_slide_top_separator_margin_bottom
);

$edgt_slide_bottom_separator_container = new HudsonEdgeContainer(
	"edgt_slide_bottom_separator_container",
	"edgt_slide-title-separator-position",
	"",
	array( "top", "left_right" )
);
$edgt_slide_title_separator_without_icon_container->addChild(
	"edgt_slide_bottom_separator_container",
	$edgt_slide_bottom_separator_container
);

$group2 = new HudsonEdgeGroup(
	esc_html__( "Bottom Separator Margins", 'hudson' ),
	esc_html__( "Enter bottom separator margins", 'hudson' )
);
$edgt_slide_bottom_separator_container->addChild(
	"group2",
	$group2
);

$row1 = new HudsonEdgeRow();
$group2->addChild(
	"row1",
	$row1
);

$edgt_slide_bottom_separator_margin_top = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-bottom-separator-margin-top",
	"",
	esc_html__( "Margin Top (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-bottom-separator-margin-top",
	$edgt_slide_bottom_separator_margin_top
);

$edgt_slide_bottom_separator_margin_bottom = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-bottom-separator-margin-bottom",
	"",
	esc_html__( "Margin Bottom (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-bottom-separator-margin-bottom",
	$edgt_slide_bottom_separator_margin_bottom
);

$edgt_slide_left_right_separator_container = new HudsonEdgeContainer(
	"edgt_slide_left_right_separator_container",
	"edgt_slide-title-separator-position",
	"",
	array( "top", "bottom", "both" )
);
$edgt_slide_title_separator_without_icon_container->addChild(
	'edgt_slide_left_right_separator_container',
	$edgt_slide_left_right_separator_container
);

$edgt_slide_left_right_separator_style = new HudsonEdgeMetaField(
	'select',
	'edgt_slide_left_right_separator_style',
	'solid',
	esc_html__( 'Line Style', 'hudson' ),
	esc_html__( 'Separator Line Style', 'hudson' ),
	array(
		"solid" => esc_html__( "Solid", 'hudson' ),
		"dashed" => esc_html__( "Dashed", 'hudson' ),
		"dotted" => esc_html__( "Dotted", 'hudson' )
	)
);
$edgt_slide_left_right_separator_container->addChild(
	'edgt_slide_left_right_separator_style',
	$edgt_slide_left_right_separator_style
);

$group3 = new HudsonEdgeGroup(
	esc_html__( 'Left/Right Separator Margins', 'hudson' ),
	esc_html__( 'Enter left and right separator margins', 'hudson' )
);
$edgt_slide_left_right_separator_container->addChild(
	'group3',
	$group3
);

$row1 = new HudsonEdgeRow();
$group3->addChild(
	'row1',
	$row1
);

$edgt_slide_left_separator_margin_right = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_left_separator_margin_right",
	"",
	esc_html__( "Left Separator Margin Right (px)", 'hudson' ),
	""
);
$row1->addChild(
	"edgt_slide_left_separator_margin_right",
	$edgt_slide_left_separator_margin_right
);

$edgt_slide_right_separator_margin_left = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_right_separator_margin_left",
	"",
	esc_html__( "Right Separator Margin Right (px)", 'hudson' ),
	""
);
$row1->addChild(
	"edgt_slide_right_separator_margin_left",
	$edgt_slide_right_separator_margin_left
);

$group4 = new HudsonEdgeGroup(
	esc_html__( 'Dots on Line End', 'hudson' ),
	esc_html__( 'Add dots on line end', 'hudson' )
);
$edgt_slide_left_right_separator_container->addChild(
	'group4',
	$group4
);

$row2 = new HudsonEdgeRow();
$group4->addChild(
	'row2',
	$row2
);

$edgt_slide_left_right_separator_linedots = new HudsonEdgeMetaField(
	'selectsimple',
	'edgt_slide_left_right_separator_linedots',
	'no',
	esc_html__( 'Dots on line end', 'hudson' ),
	'',
	array(
		'no' => esc_html__( 'No', 'hudson' ),
		'yes' => esc_html__( 'Yes', 'hudson' ),
	)
);
$row2->addChild(
	'edgt_slide_left_right_separator_linedots',
	$edgt_slide_left_right_separator_linedots
);

$edgt_slide_left_right_separator_line_dots_size = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_slide_left_right_separator_line_dots_size',
	'',
	esc_html__( 'Dots Size (px)', 'hudson' ),
	''
);
$row2->addChild(
	'edgt_slide_left_right_separator_line_dots_size',
	$edgt_slide_left_right_separator_line_dots_size
);

$edgt_slide_left_right_separator_dots_color = new HudsonEdgeMetaField(
	'colorsimple',
	'edgt_slide_left_right_separator_dots_color',
	'',
	esc_html__( 'Dots Color', 'hudson' ),
	''
);
$row2->addChild(
	'edgt_slide_left_right_separator_dots_color',
	$edgt_slide_left_right_separator_dots_color
);

//Separator Position With Icon
$edgt_slide_title_separator_with_icon_position = new HudsonEdgeMetaField(
	"select",
	"edgt_slide_title_separator_with_icon_position",
	"both",
	esc_html__( "Position", 'hudson' ),
	esc_html__( "Choose position of slider separator", 'hudson' ),
	array(
		"top" => esc_html__( "Top", 'hudson' ),
		"bottom" => esc_html__( "Bottom", 'hudson' )
	)
);
$edgt_slide_title_separator_with_icon_container->addChild(
	"edgt_slide_title_separator_with_icon_position",
	$edgt_slide_title_separator_with_icon_position
);

//Separator Position With Custom Icon
$edgt_slide_title_separator_with_custom_icon_position = new HudsonEdgeMetaField(
	"select",
	"edgt_slide_title_separator_with_custom_icon_position",
	"both",
	esc_html__( "Position", 'hudson' ),
	esc_html__( "Choose position of slider separator", 'hudson' ),
	array(
		"top" => esc_html__( "Top", 'hudson' ),
		"bottom" => esc_html__( "Bottom", 'hudson' )
	)
);
$edgt_slide_title_separator_with_custom_icon_container->addChild(
	'edgt_slide_title_separator_with_custom_icon_position',
	$edgt_slide_title_separator_with_custom_icon_position
);

//Slide Subtitle

$edgtSlideSubtitle = new HudsonEdgeMetaBox(
	"slides",
	esc_html__( "Slide Subtitle Style", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"slides_subtitle",
	$edgtSlideSubtitle
);

$subtitle_text_group = new HudsonEdgeGroup(
	esc_html__( "Subtitle Text Style", 'hudson' ),
	esc_html__( "Define styles for subtitle text", 'hudson' )
);
$edgtSlideSubtitle->addChild(
	"subtitle_text_group",
	$subtitle_text_group
);
$row1 = new HudsonEdgeRow();
$subtitle_text_group->addChild(
	"row1",
	$row1
);
$subtitle_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-subtitle-color",
	"",
	esc_html__( "Font Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-subtitle-color",
	$subtitle_color
);
$subtitle_fontsize = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-subtitle-font-size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-subtitle-font-size",
	$subtitle_fontsize
);
$subtitle_lineheight = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-subtitle-line-height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-subtitle-line-height",
	$subtitle_lineheight
);
$subtitle_letterspacing = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-subtitle-letter-spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-subtitle-letter-spacing",
	$subtitle_letterspacing
);

$row2 = new HudsonEdgeRow( true );
$subtitle_text_group->addChild(
	"row2",
	$row2
);
$subtitle_google_fonts = new HudsonEdgeMetaField(
	"fontsimple",
	"edgt_slide-subtitle-font-family",
	"",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"edgt_slide-subtitle-font-family",
	$subtitle_google_fonts
);
$subtitle_fontstyle = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-subtitle-font-style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"edgt_slide-subtitle-font-style",
	$subtitle_fontstyle
);
$subtitle_fontweight = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-subtitle-font-weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"edgt_slide-subtitle-font-weight",
	$subtitle_fontweight
);
$subtitle_transform = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-subtitle-text-transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"edgt_slide-subtitle-text-transform",
	$subtitle_transform
);

$subtitle_background_group = new HudsonEdgeGroup(
	esc_html__( "Background", 'hudson' ),
	esc_html__( "Define background for subtitle", 'hudson' )
);
$edgtSlideSubtitle->addChild(
	"subtitle_background_group",
	$subtitle_background_group
);
$row1 = new HudsonEdgeRow( true );
$subtitle_background_group->addChild(
	"row1",
	$row1
);
$subtitle_background_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-subtitle-background-color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-subtitle-background-color",
	$subtitle_background_color
);
$subtitle_background_color_transparency = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-subtitle-bg-color-transparency",
	"",
	esc_html__( "Background Color Transparency (values: 0-1)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-subtitle-bg-color-transparency",
	$subtitle_background_color_transparency
);

$subtitle_margin_group = new HudsonEdgeGroup(
	esc_html__( "Margin Bottom (px)", 'hudson' ),
	esc_html__( "Enter value for subtitle bottom margin (default value is 14)", 'hudson' )
);
$edgtSlideSubtitle->addChild(
	"subtitle_margin_group",
	$subtitle_margin_group
);
$row1 = new HudsonEdgeRow( true );
$subtitle_margin_group->addChild(
	"row1",
	$row1
);
$subtitle_margin_bottom = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_subtitle_margin_bottom",
	"",
	"",
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_subtitle_margin_bottom",
	$subtitle_margin_bottom
);

$subtitle_padding_group = new HudsonEdgeGroup(
	esc_html__( "Padding", 'hudson' ),
	esc_html__( "Define padding for subtitle", 'hudson' )
);
$edgtSlideSubtitle->addChild(
	"subtitle_padding_group",
	$subtitle_padding_group
);
$row1 = new HudsonEdgeRow( true );
$subtitle_padding_group->addChild(
	"row1",
	$row1
);
$subtitle_padding_top = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_subtitle_padding_top",
	"",
	esc_html__( "Top Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_subtitle_padding_top",
	$subtitle_padding_top
);
$subtitle_padding_right = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_subtitle_padding_right",
	"",
	esc_html__( "Right Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_subtitle_padding_right",
	$subtitle_padding_right
);
$subtitle_padding_bottom = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_subtitle_padding_bottom",
	"",
	esc_html__( "Bottom Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_subtitle_padding_bottom",
	$subtitle_padding_bottom
);
$subtitle_padding_left = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_subtitle_padding_left",
	"",
	esc_html__( "Left Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_subtitle_padding_left",
	$subtitle_padding_left
);

//Slide Text

$edgtSlideText = new HudsonEdgeMetaBox(
	"slides",
	esc_html__( "Slide Text Style", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"slides_text",
	$edgtSlideText
);

$text_common_text_group = new HudsonEdgeGroup(
	esc_html__( 'Text Color and Size', 'hudson' ),
	esc_html__( 'Define text color and size', 'hudson' )
);
$edgtSlideText->addChild(
	'text_common_text_group',
	$text_common_text_group
);

$row1 = new HudsonEdgeRow();
$text_common_text_group->addChild(
	'row1',
	$row1
);

$text_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-text-color",
	"",
	esc_html__( "Font Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-text-color",
	$text_color
);
$text_background_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-text-background-color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-text-background-color",
	$text_background_color
);
$text_fontsize = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-text-font-size",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-text-font-size",
	$text_fontsize
);
$text_lineheight = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-text-line-height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-text-line-height",
	$text_lineheight
);

$text_without_separator_text_group = new HudsonEdgeGroup(
	esc_html__( "Text Style", 'hudson' ),
	esc_html__( "Define styles for text text", 'hudson' )
);
$edgtSlideText->addChild(
	"text_without_separator_text_group",
	$text_without_separator_text_group
);

$row1 = new HudsonEdgeRow();
$text_without_separator_text_group->addChild(
	"row1",
	$row1
);

$text_letterspacing = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-text-letter-spacing",
	"",
	esc_html__( "Letter Spacing (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-text-letter-spacing",
	$text_letterspacing
);

$row2 = new HudsonEdgeRow( true );
$text_without_separator_text_group->addChild(
	"row2",
	$row2
);

$text_google_fonts = new HudsonEdgeMetaField(
	"fontsimple",
	"edgt_slide-text-font-family",
	"",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"edgt_slide-text-font-family",
	$text_google_fonts
);
$text_fontstyle = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-text-font-style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row2->addChild(
	"edgt_slide-text-font-style",
	$text_fontstyle
);
$text_fontweight = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-text-font-weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row2->addChild(
	"edgt_slide-text-font-weight",
	$text_fontweight
);
$text_transform = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-text-text-transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row2->addChild(
	"edgt_slide-text-text-transform",
	$text_transform
);

$text_separator_text = new HudsonEdgeMetaField(
	'yesno',
	'text_separator_text',
	'no',
	esc_html__( 'Separator Around Text', 'hudson' ),
	esc_html__( 'Do you want to have a separator around text', 'hudson' ),
	array(),
	array(
		'dependence'             => true,
		'dependence_hide_on_yes' => '#edgtf_text_without_separator_container',
		'dependence_show_on_yes' => '#edgtf_text_with_separator_container'
	)
);
$edgtSlideText->addChild(
	'text_separator_text',
	$text_separator_text
);

$text_without_separator_container = new HudsonEdgeContainerNoStyle(
	'text_without_separator_container',
	'text_separator_text',
	'yes'
);
$edgtSlideText->addChild(
	'text_without_separator_container',
	$text_without_separator_container
);

$text_without_separator_padding_group = new HudsonEdgeGroup(
	esc_html__( "Padding", 'hudson' ),
	esc_html__( "Define padding for text", 'hudson' )
);
$text_without_separator_container->addChild(
	"text_without_separator_padding_group",
	$text_without_separator_padding_group
);

$row1 = new HudsonEdgeRow( true );
$text_without_separator_padding_group->addChild(
	"row1",
	$row1
);

$text_padding_top = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_text_padding_top",
	"",
	esc_html__( "Top Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_text_padding_top",
	$text_padding_top
);
$text_padding_right = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_text_padding_right",
	"",
	esc_html__( "Right Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_text_padding_right",
	$text_padding_right
);
$text_padding_bottom = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_text_padding_bottom",
	"",
	esc_html__( "Bottom Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_text_padding_bottom",
	$text_padding_bottom
);
$text_padding_left = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_text_padding_left",
	"",
	esc_html__( "Left Padding (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_text_padding_left",
	$text_padding_left
);

$text_without_separator_background_group = new HudsonEdgeGroup(
	esc_html__( "Background", 'hudson' ),
	esc_html__( "Define background for text", 'hudson' )
);
$text_without_separator_container->addChild(
	"text_without_separator_background_group",
	$text_without_separator_background_group
);

$row1 = new HudsonEdgeRow( true );
$text_without_separator_background_group->addChild(
	"row1",
	$row1
);

$text_background_color_transparency = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-text-bg-color-transparency",
	"",
	esc_html__( "Background Color Transparency (values 0-1)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-text-bg-color-transparency",
	$text_background_color_transparency
);

$text_with_separator_container = new HudsonEdgeContainer(
	'text_with_separator_container',
	'text_separator_text',
	'no'
);
$edgtSlideText->addChild(
	'text_with_separator_container',
	$text_with_separator_container
);

$text_with_separator_border_styles = new HudsonEdgeGroup(
	esc_html__( 'Separator Line Style', 'hudson' ),
	esc_html__( 'Define separator line style', 'hudson' )
);
$text_with_separator_container->addChild(
	'text_with_separator_border_styles',
	$text_with_separator_border_styles
);

$row1 = new HudsonEdgeRow();
$text_with_separator_border_styles->addChild(
	'row1',
	$row1
);

$edgt_separator_line_border_style = new HudsonEdgeMetaField(
	'selectsimple',
	'edgt_separator_line_border_style',
	'solid',
	esc_html__( 'Line Border Style', 'hudson' ),
	'',
	array(
		'solid' => esc_html__( 'Solid', 'hudson' ),
		'dashed' => esc_html__( 'Dashed', 'hudson' ),
		'dotted' => esc_html__( 'Dotted', 'hudson' ),
		'transparent' => esc_html__( 'Transparent', 'hudson' )
	)
);
$row1->addChild(
	'edgt_separator_line_border_style',
	$edgt_separator_line_border_style
);

$edgt_separator_line_width = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_separator_line_width',
	'',
	esc_html__( 'Line Width (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_separator_line_width',
	$edgt_separator_line_width
);

$edgt_separator_line_thickness = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_separator_line_thickness',
	'',
	esc_html__( 'Line Thickness (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_separator_line_thickness',
	$edgt_separator_line_thickness
);

$edgt_separator_line_color = new HudsonEdgeMetaField(
	'colorsimple',
	'edgt_separator_line_color',
	'',
	esc_html__( 'Line Color', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_separator_line_color',
	$edgt_separator_line_color
);

$text_with_separator_boxed = new HudsonEdgeGroup(
	esc_html__( 'Boxed Text', 'hudson' ),
	esc_html__( 'Add box around text', 'hudson' )
);
$text_with_separator_container->addChild(
	'text_with_separator_boxed',
	$text_with_separator_boxed
);

$row1 = new HudsonEdgeRow();
$text_with_separator_boxed->addChild(
	'row1',
	$row1
);

$edgt_separator_text_in_box = new HudsonEdgeMetaField(
	'selectsimple',
	'edgt_separator_text_in_box',
	'no',
	esc_html__( 'Text in Box', 'hudson' ),
	'',
	array(
		'yes' => esc_html__( 'Yes', 'hudson' ),
		'no' => esc_html__( 'No', 'hudson' )
	)
);
$row1->addChild(
	'edgt_separator_text_in_box',
	$edgt_separator_text_in_box
);

$edgt_separator_box_border_style = new HudsonEdgeMetaField(
	'selectsimple',
	'edgt_separator_box_border_style',
	'solid',
	esc_html__( 'Box Border Style', 'hudson' ),
	'',
	array(
		'solid' => esc_html__( 'Solid', 'hudson' ),
		'dashed' => esc_html__( 'Dashed', 'hudson' ),
		'dotted' => esc_html__( 'Dotted', 'hudson' ),
		'transparent' => esc_html__( 'Transparent', 'hudson' )
	)
);
$row1->addChild(
	'edgt_separator_box_border_style',
	$edgt_separator_box_border_style
);

$edgt_separator_box_border_width = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_separator_box_border_width',
	'',
	esc_html__( 'Box Border Width (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_separator_box_border_width',
	$edgt_separator_box_border_width
);

$edgt_separator_box_border_radius = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_separator_box_border_radius',
	'',
	esc_html__( 'Box Border Radius (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_separator_box_border_radius',
	$edgt_separator_box_border_radius
);

$row2 = new HudsonEdgeRow( true );
$text_with_separator_boxed->addChild(
	'row2',
	$row2
);

$edgt_separator_box_border_color = new HudsonEdgeMetaField(
	'colorsimple',
	'edgt_separator_box_border_color',
	'',
	esc_html__( 'Box Border Color', 'hudson' ),
	''
);
$row2->addChild(
	'edgt_separator_box_border_color',
	$edgt_separator_box_border_color
);

$text_with_separator_position = new HudsonEdgeGroup(
	esc_html__( 'Text Position', 'hudson' ),
	esc_html__( 'Define position of text', 'hudson' )
);
$text_with_separator_container->addChild(
	'text_with_separator_position',
	$text_with_separator_position
);

$row1 = new HudsonEdgeRow();
$text_with_separator_position->addChild(
	'row1',
	$row1
);

$edgt_separator_text_position = new HudsonEdgeMetaField(
	'selectsimple',
	'edgt_separator_text_position',
	'center',
	esc_html__( 'Text position', 'hudson' ),
	'',
	array(
		'center' => esc_html__( 'Center', 'hudson' ),
		'left' => esc_html__( 'Left', 'hudson' ),
		'right' => esc_html__( 'Right', 'hudson' )
	)
);
$row1->addChild(
	'edgt_separator_text_position',
	$edgt_separator_text_position
);

$edgt_separator_text_leftright_padding = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_separator_text_leftright_padding',
	'',
	esc_html__( 'Left/Right Text padding (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_separator_text_leftright_padding',
	$edgt_separator_text_leftright_padding
);

$edgt_separator_text_top_margin = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_separator_text_top_margin',
	'',
	esc_html__( 'Top Margin (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_separator_text_top_margin',
	$edgt_separator_text_top_margin
);

$edgt_separator_text_bottom_margin = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_separator_text_bottom_margin',
	'',
	esc_html__( 'Bottom Margin (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_separator_text_bottom_margin',
	$edgt_separator_text_bottom_margin
);

$row2 = new HudsonEdgeRow( true );
$text_with_separator_position->addChild(
	'row2',
	$row2
);

$edgt_separator_box_margin = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_separator_box_margin',
	'',
	esc_html__( 'Box Margins Left/Right (px)', 'hudson' ),
	''
);
$row2->addChild(
	'edgt_separator_box_margin',
	$edgt_separator_box_margin
);

$text_with_separator_linedots = new HudsonEdgeGroup(
	esc_html__( 'Dots on Line End', 'hudson' ),
	esc_html__( 'Add dots on line end', 'hudson' )
);
$text_with_separator_container->addChild(
	'text_with_separator_linedots',
	$text_with_separator_linedots
);

$row1 = new HudsonEdgeRow();
$text_with_separator_linedots->addChild(
	'row1',
	$row1
);

$edgt_separator_linedots = new HudsonEdgeMetaField(
	'selectsimple',
	'edgt_separator_linedots',
	'no',
	esc_html__( 'Dots on line end', 'hudson' ),
	'',
	array(
		'no' => esc_html__( 'No', 'hudson' ),
		'yes' => esc_html__( 'Yes', 'hudson' ),
	)
);
$row1->addChild(
	'edgt_separator_linedots',
	$edgt_separator_linedots
);

$edgt_separator_line_dots_size = new HudsonEdgeMetaField(
	'textsimple',
	'edgt_separator_line_dots_size',
	'',
	esc_html__( 'Dots Size (px)', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_separator_line_dots_size',
	$edgt_separator_line_dots_size
);

$edgt_separator_dots_color = new HudsonEdgeMetaField(
	'colorsimple',
	'edgt_separator_dots_color',
	'',
	esc_html__( 'Dots Color', 'hudson' ),
	''
);
$row1->addChild(
	'edgt_separator_dots_color',
	$edgt_separator_dots_color
);

$edgt_text_with_separator_animate = new HudsonEdgeMetaField(
	"select",
	"edgt_text_with_separator_animate",
	"",
	esc_html__( "Animate", 'hudson' ),
	esc_html__( "Choose animation for separator (width will be fixed to 260px)", 'hudson' ),
	array(
		"" => esc_html__( "No Animation", 'hudson' ),
		"animate_width" => esc_html__( "Animate Width", 'hudson' )
	)
);
$text_with_separator_container->addChild(
	"edgt_text_with_separator_animate",
	$edgt_text_with_separator_animate
);

//Slide Buttons
//Button 1
$edgtSlideButtons = new HudsonEdgeMetaBox(
	"slides",
	esc_html__( "Slide Buttons Style", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"slides_buttons",
	$edgtSlideButtons
);

$button1_section = new HudsonEdgeTitle(
	"button1_section",
	esc_html__( "Button 1", 'hudson' )
);
$edgtSlideButtons->addChild(
	"button1_section",
	$button1_section
);

$button1_group2 = new HudsonEdgeGroup(
	esc_html__( "Text Style", 'hudson' ),
	esc_html__( "Define text style", 'hudson' )
);
$edgtSlideButtons->addChild(
	"button1_group2",
	$button1_group2
);

$row1 = new HudsonEdgeRow();
$button1_group2->addChild(
	"row1",
	$row1
);
$button1_font_family = new HudsonEdgeMetaField(
	"fontsimple",
	"edgt_slide-button_font_family",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_font_family",
	$button1_font_family
);
$button1_font_size = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_font_size",
	"",
	esc_html__( "Text Size(px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_font_size",
	$button1_font_size
);
$button1_font_style = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-button_font_style",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row1->addChild(
	"edgt_slide-button_font_style",
	$button1_font_style
);
$button1_font_weight = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-button_font_weight",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row1->addChild(
	"edgt_slide-button_font_weight",
	$button1_font_weight
);

$row2 = new HudsonEdgeRow();
$button1_group2->addChild(
	"row2",
	$row2
);

$button1_letter_spacing = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_letter_spacing",
	"",
	esc_html__( "Letter Spacing(px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"edgt_slide-button_letter_spacing",
	$button1_letter_spacing
);

$button1_line_height = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_line_height",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"edgt_slide-button_line_height",
	$button1_line_height
);

$button1_text_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-button_text_color",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"edgt_slide-button_text_color",
	$button1_text_color
);

$button1_text_hover_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-button_text_hover_color",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"edgt_slide-button_text_hover_color",
	$button1_text_hover_color
);

$row3 = new HudsonEdgeRow();
$button1_group2->addChild(
	"row3",
	$row3
);

$button1_text_align = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-button_text_align",
	"",
	esc_html__( "Text Align", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$row3->addChild(
	"edgt_slide-button_text_align",
	$button1_text_align
);
$button1_text_transform = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-button_text_transform",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"edgt_slide-button_text_transform",
	$button1_text_transform
);

$button1_group3 = new HudsonEdgeGroup(
	esc_html__( "Background", 'hudson' ),
	esc_html__( "Define background", 'hudson' )
);
$edgtSlideButtons->addChild(
	"button1_group3",
	$button1_group3
);

$row1 = new HudsonEdgeRow();
$button1_group3->addChild(
	"row1",
	$row1
);

$button1_background_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-button_background_color",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_background_color",
	$button1_background_color
);

$button1_background_hover_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-button_background_hover_color",
	"",
	esc_html__( "Background Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_background_hover_color",
	$button1_background_hover_color
);

$button1_group4 = new HudsonEdgeGroup(
	esc_html__( "Size", 'hudson' ),
	esc_html__( "Define button size", 'hudson' )
);
$edgtSlideButtons->addChild(
	"button1_group4",
	$button1_group4
);

$row1 = new HudsonEdgeRow();
$button1_group4->addChild(
	"row1",
	$row1
);

$button1_width = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_width",
	"",
	esc_html__( "Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_width",
	$button1_width
);

$button1_height = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_height",
	"",
	esc_html__( "Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_height",
	$button1_height
);

$button1_group5 = new HudsonEdgeGroup(
	esc_html__( "Border", 'hudson' ),
	esc_html__( "Define border style", 'hudson' )
);
$edgtSlideButtons->addChild(
	"button1_group5",
	$button1_group5
);

$row1 = new HudsonEdgeRow();
$button1_group5->addChild(
	"row1",
	$row1
);

$button1_border_width = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_border_width",
	"",
	esc_html__( "Border Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_border_width",
	$button1_border_width
);

$button1_border_radius = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_border_radius",
	"",
	esc_html__( "Border Radius (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_border_radius",
	$button1_border_radius
);

$button1_border_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-button_border_color",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_border_color",
	$button1_border_color
);

$button1_border_hover_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-button_border_hover_color",
	"",
	esc_html__( "Border Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_border_hover_color",
	$button1_border_hover_color
);

$button1_margin = new HudsonEdgeMetaField(
	"text",
	"edgt_slide-button_margin1",
	"",
	esc_html__( "Margin (px)", 'hudson' ),
	esc_html__( "Please insert margin in format (top right bottom left) i.e. 5px 5px 5px 5px", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgtSlideButtons->addChild(
	"edgt_slide-button_margin1",
	$button1_margin
);

$button1_group6 = new HudsonEdgeGroup(
	esc_html__( "Padding", 'hudson' ),
	esc_html__( "Define left/right padding for button (px)", 'hudson' )
);
$edgtSlideButtons->addChild(
	"button1_group6",
	$button1_group6
);

$row1 = new HudsonEdgeRow( true );
$button1_group6->addChild(
	"row1",
	$row1
);

$button1_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_padding",
	"",
	"",
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_padding",
	$button1_padding
);

$button1_group7 = new HudsonEdgeGroup(
	esc_html__( "Button Hover Animation", 'hudson' ),
	esc_html__( "Define hover animation for button", 'hudson' )
);
$edgtSlideButtons->addChild(
	"button1_group7",
	$button1_group7
);

$row1 = new HudsonEdgeRow( true );
$button1_group7->addChild(
	"row1",
	$row1
);

$button1_hover_button_animation = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-button1_hover_button_animation",
	"",
	esc_html__( "Hover Animation", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"fill_from_top" => esc_html__( "Fill From Top", 'hudson' ),
		"fill_from_left" => esc_html__( "Fill From Left", 'hudson' ),
		"fill_from_bottom" => esc_html__( "Fill From Bottom", 'hudson' ),
		"fill_diagonal" => esc_html__( "Fill Diagonal", 'hudson' )
	)
);
$row1->addChild(
	"edgt_slide-button1_hover_button_animation",
	$button1_hover_button_animation
);

//init icon pack hide and show array. It will be populated dinamically from collections array
$button1_icon_pack_hide_array = array();
$button1_icon_pack_show_array = array();

//do we have some collection added in collections array?
if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//get collections params array. It will contain values of 'param' property for each collection
	$button1_icon_collections_params = $hudson_edge_icon_collections->getIconCollectionsParams();
	
	//foreach collection generate hide and show array
	foreach ( $hudson_edge_icon_collections->iconCollections as $dep_collection_key => $dep_collection_object ) {
		$button1_icon_pack_hide_array[ $dep_collection_key ] = '';
		$button1_icon_pack_hide_array["no_icon"]             = "";
		
		//button1_icon_size is input that is always shown when some icon pack is activated and hidden if 'no_icon' is selected
		$button1_icon_pack_hide_array["no_icon"] .= "#edgtf_button1_style_container,";
		
		//we need to include only current collection in show string as it is the only one that needs to show
		$button1_icon_pack_show_array[ $dep_collection_key ] = '#edgtf_button1_style_container, #edgtf_button1_icon_' . $dep_collection_object->param . '_container';
		
		//for all collections param generate hide string
		foreach ( $button1_icon_collections_params as $button1_icon_collections_param ) {
			//we don't need to include current one, because it needs to be shown, not hidden
			if ( $button1_icon_collections_param !== $dep_collection_object->param ) {
				$button1_icon_pack_hide_array[ $dep_collection_key ] .= '#edgtf_button1_icon_' . $button1_icon_collections_param . '_container,';
			}
			
			$button1_icon_pack_hide_array["no_icon"] .= '#edgtf_button1_icon_' . $button1_icon_collections_param . '_container,';
		}
		
		//remove remaining ',' character
		$button1_icon_pack_hide_array[ $dep_collection_key ] = rtrim(
			$button1_icon_pack_hide_array[ $dep_collection_key ],
			','
		);
		$button1_icon_pack_hide_array["no_icon"]             = rtrim(
			$button1_icon_pack_hide_array["no_icon"],
			','
		);
	}
	
}

$button1_icon_pack = new HudsonEdgeMetaField(
	"select",
	"button1_icon_pack",
	"no_icon",
	esc_html__( "Button 1 Icon Pack", 'hudson' ),
	esc_html__( "Choose icon pack for first button", 'hudson' ),
	$hudson_edge_icon_collections->getIconCollectionsEmpty( "no_icon" ),
	array(
		"dependence" => true,
		"hide"       => $button1_icon_pack_hide_array,
		"show"       => $button1_icon_pack_show_array
	)
);

$edgtSlideButtons->addChild(
	"button1_icon_pack",
	$button1_icon_pack
);

if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//foreach icon collection we need to generate separate container that will have dependency set
	//it will have one field inside with icons dropdown
	foreach ( $hudson_edge_icon_collections->iconCollections as $collection_key => $collection_object ) {
		$icons_array = $collection_object->getIconsArray();
		
		//get icon collection keys (keys from collections array, e.g 'font_awesome', 'font_elegant' etc.)
		$icon_collections_keys = $hudson_edge_icon_collections->getIconCollectionsKeys();
		
		//unset current one, because it doesn't have to be included in dependency that hides icon container
		unset(
			$icon_collections_keys[ array_search(
				$collection_key,
				$icon_collections_keys
			) ]
		);
		
		$button1_icon_hide_values   = $icon_collections_keys;
		$button1_icon_hide_values[] = "no_icon";
		$button1_icon_container     = new HudsonEdgeContainer(
			"button1_icon_" . $collection_object->param . "_container",
			"button1_icon_pack",
			"",
			$button1_icon_hide_values
		);
		$button1_icon               = new HudsonEdgeMetaField(
			"select",
			"button1_icon_" . $collection_object->param,
			"",
			esc_html__( "Button 1 Icon", 'hudson' ),
			esc_html__( "Choose First Button Icon", 'hudson' ),
			$icons_array,
			array( "col_width" => 3 )
		);
		$button1_icon_container->addChild(
			"button1_icon_" . $collection_object->param,
			$button1_icon
		);
		
		$edgtSlideButtons->addChild(
			"button1_icon_" . $collection_object->param . "_container",
			$button1_icon_container
		);
	}
	
}

$button1_style_container = new HudsonEdgeContainer(
	"button1_style_container",
	"button1_icon_pack",
	"no_icon"
);
$edgtSlideButtons->addChild(
	"button1_style_container",
	$button1_style_container
);

$button1_style = new HudsonEdgeGroup(
	esc_html__( "Button 1 Style", 'hudson' ),
	esc_html__( "Define button 1 style", 'hudson' )
);
$button1_style_container->addChild(
	"button1_style",
	$button1_style
);

$row1 = new HudsonEdgeRow( true );
$button1_style->addChild(
	"row1",
	$row1
);

$slider_button1_icon_color = new HudsonEdgeMetaField(
	"colorsimple",
	"slider_button1_icon_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	""
);
$row1->addChild(
	"slider_button1_icon_color",
	$slider_button1_icon_color
);

$slider_button1_icon_hover_color = new HudsonEdgeMetaField(
	"colorsimple",
	"slider_button1_icon_hover_color",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	""
);
$row1->addChild(
	"slider_button1_icon_hover_color",
	$slider_button1_icon_hover_color
);

$slider_button1_icon_size = new HudsonEdgeMetaField(
	"textsimple",
	"slider_button1_icon_size",
	"",
	esc_html__( "Icon Size (px)", 'hudson' ),
	""
);
$row1->addChild(
	"slider_button1_icon_size",
	$slider_button1_icon_size
);

$slider_button1_icon_hover_animation = new HudsonEdgeMetaField(
	"selectblanksimple",
	"slider_button1_icon_hover_animation",
	"",
	esc_html__( "Hover Animtion", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"move_icon" => esc_html__( "Move Icon", 'hudson' )
	)
);
$row1->addChild(
	"slider_button1_icon_hover_animation",
	$slider_button1_icon_hover_animation
);

//Button 2
$button2_section = new HudsonEdgeTitle(
	"button2_section",
	esc_html__( "Button 2", 'hudson' )
);
$edgtSlideButtons->addChild(
	"button2_section",
	$button2_section
);

$button2_group2 = new HudsonEdgeGroup(
	esc_html__( "Text Style", 'hudson' ),
	esc_html__( "Define text style", 'hudson' )
);
$edgtSlideButtons->addChild(
	"button2_group2",
	$button2_group2
);
$row1 = new HudsonEdgeRow();
$button2_group2->addChild(
	"row1",
	$row1
);

$button2_font_family = new HudsonEdgeMetaField(
	"fontsimple",
	"edgt_slide-button_font_family2",
	"-1",
	esc_html__( "Font Family", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_font_family2",
	$button2_font_family
);
$button2_font_size = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_font_size2",
	"",
	esc_html__( "Font Size (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_font_size2",
	$button2_font_size
);
$button2_font_style = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-button_font_style2",
	"",
	esc_html__( "Font Style", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontstyle()
);
$row1->addChild(
	"edgt_slide-button_font_style2",
	$button2_font_style
);
$button2_font_weight = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-button_font_weight2",
	"",
	esc_html__( "Font Weight", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_fontweight()
);
$row1->addChild(
	"edgt_slide-button_font_weight2",
	$button2_font_weight
);

$row2 = new HudsonEdgeRow();
$button2_group2->addChild(
	"row2",
	$row2
);
$button2_letter_spacing = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_letter_spacing2",
	"",
	esc_html__( "Letter Spacing(px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"edgt_slide-button_letter_spacing2",
	$button2_letter_spacing
);
$button2_line_height = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_line_height2",
	"",
	esc_html__( "Line Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"edgt_slide-button_line_height2",
	$button2_line_height
);
$button2_text_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-button_text_color2",
	"",
	esc_html__( "Text Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"edgt_slide-button_text_color2",
	$button2_text_color
);
$button2_text_hover_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-button_text_hover_color2",
	"",
	esc_html__( "Text Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"edgt_slide-button_text_hover_color2",
	$button2_text_hover_color
);

$row3 = new HudsonEdgeRow();
$button2_group2->addChild(
	"row3",
	$row3
);
$button2_text_align = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-button_text_align2",
	"",
	esc_html__( "Text Align", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$row3->addChild(
	"edgt_slide-button_text_align2",
	$button2_text_align
);
$button2_text_transform = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-button_text_transform2",
	"",
	esc_html__( "Text Transform", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	hudson_edge_return_options_texttransform()
);
$row3->addChild(
	"edgt_slide-button_text_transform2",
	$button2_text_transform
);

$button2_group3 = new HudsonEdgeGroup(
	esc_html__( "Background", 'hudson' ),
	esc_html__( "Define background", 'hudson' )
);
$edgtSlideButtons->addChild(
	"button2_group3",
	$button2_group3
);
$row4 = new HudsonEdgeRow();
$button2_group3->addChild(
	"row4",
	$row4
);
$button2_background_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-button_background_color2",
	"",
	esc_html__( "Background Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"edgt_slide-button_background_color2",
	$button2_background_color
);
$button2_background_hover_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-button_background_hover_color2",
	"",
	esc_html__( "Background Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row4->addChild(
	"edgt_slide-button_background_hover_color2",
	$button2_background_hover_color
);

$button2_group4 = new HudsonEdgeGroup(
	esc_html__( "Size", 'hudson' ),
	esc_html__( "Define button size", 'hudson' )
);
$edgtSlideButtons->addChild(
	"button2_group4",
	$button2_group4
);
$row1 = new HudsonEdgeRow();
$button2_group4->addChild(
	"row1",
	$row1
);
$button2_width = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_width2",
	"",
	esc_html__( "Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_width2",
	$button2_width
);
$button2_height = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_height2",
	"",
	esc_html__( "Height (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_height2",
	$button2_height
);

$button2_group5 = new HudsonEdgeGroup(
	esc_html__( "Border", 'hudson' ),
	esc_html__( "Define border style", 'hudson' )
);
$edgtSlideButtons->addChild(
	"button2_group5",
	$button2_group5
);
$row1 = new HudsonEdgeRow();
$button2_group5->addChild(
	"row1",
	$row1
);
$button2_border_width = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_border_width2",
	"",
	esc_html__( "Border Width (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_border_width2",
	$button2_border_width
);
$button2_border_radius = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_border_radius2",
	"",
	esc_html__( "Border Radius (px)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_border_radius2",
	$button2_border_radius
);
$button2_border_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-button_border_color2",
	"",
	esc_html__( "Border Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_border_color2",
	$button2_border_color
);
$button2_border_hover_color = new HudsonEdgeMetaField(
	"colorsimple",
	"edgt_slide-button_border_hover_color2",
	"",
	esc_html__( "Border Hover Color", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_border_hover_color2",
	$button2_border_hover_color
);

$button2_margin = new HudsonEdgeMetaField(
	"text",
	"edgt_slide-button_margin2",
	"",
	esc_html__( "Margin (px)", 'hudson' ),
	esc_html__( "Please insert margin in format (top right bottom left) i.e. 5px 5px 5px 5px", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgtSlideButtons->addChild(
	"edgt_slide-button_margin2",
	$button2_margin
);

$button2_group6 = new HudsonEdgeGroup(
	esc_html__( "Padding", 'hudson' ),
	esc_html__( "Define left/right padding for button (px)", 'hudson' )
);
$edgtSlideButtons->addChild(
	"button2_group6",
	$button2_group6
);

$row1 = new HudsonEdgeRow( true );
$button2_group6->addChild(
	"row1",
	$row1
);

$button2_padding = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-button_padding2",
	"",
	"",
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-button_padding2",
	$button2_padding
);

$button2_group7 = new HudsonEdgeGroup(
	esc_html__( "Button Hover Animation", 'hudson' ),
	esc_html__( "Define hover animation for button", 'hudson' )
);
$edgtSlideButtons->addChild(
	"button2_group7",
	$button2_group7
);

$row1 = new HudsonEdgeRow( true );
$button2_group7->addChild(
	"row1",
	$row1
);

$button2_hover_button_animation = new HudsonEdgeMetaField(
	"selectblanksimple",
	"edgt_slide-button2_hover_button_animation",
	"",
	esc_html__( "Hover Animation", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"fill_from_top" => esc_html__( "Fill From Top", 'hudson' ),
		"fill_from_left" => esc_html__( "Fill From Left", 'hudson' ),
		"fill_from_bottom" => esc_html__( "Fill From Bottom", 'hudson' ),
		"fill_diagonal" => esc_html__( "Fill Diagonal", 'hudson' )
	)
);
$row1->addChild(
	"edgt_slide-button2_hover_button_animation",
	$button2_hover_button_animation
);

//init icon pack hide and show array. It will be populated dinamically from collections array
$button2_icon_pack_hide_array = array();
$button2_icon_pack_show_array = array();

//do we have some collection added in collections array?
if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//get collections params array. It will contain values of 'param' property for each collection
	$button2_icon_collections_params = $hudson_edge_icon_collections->getIconCollectionsParams();
	
	//foreach collection generate hide and show array
	foreach ( $hudson_edge_icon_collections->iconCollections as $dep_collection_key => $dep_collection_object ) {
		$button2_icon_pack_hide_array[ $dep_collection_key ] = '';
		$button2_icon_pack_hide_array["no_icon"]             = "";
		
		//button2_icon_size is input that is always shown when some icon pack is activated and hidden if 'no_icon' is selected
		$button2_icon_pack_hide_array["no_icon"] .= "#edgtf_button2_style_container,";
		
		//we need to include only current collection in show string as it is the only one that needs to show
		$button2_icon_pack_show_array[ $dep_collection_key ] = '#edgtf_button2_style_container,#edgtf_button2_icon_' . $dep_collection_object->param . '_container';
		
		//for all collections param generate hide string
		foreach ( $button2_icon_collections_params as $button2_icon_collections_param ) {
			//we don't need to include current one, because it needs to be shown, not hidden
			if ( $button2_icon_collections_param !== $dep_collection_object->param ) {
				$button2_icon_pack_hide_array[ $dep_collection_key ] .= '#edgtf_button2_icon_' . $button2_icon_collections_param . '_container,';
			}
			
			$button2_icon_pack_hide_array["no_icon"] .= '#edgtf_button2_icon_' . $button2_icon_collections_param . '_container,';
		}
		
		//remove remaining ',' character
		$button2_icon_pack_hide_array[ $dep_collection_key ] = rtrim(
			$button2_icon_pack_hide_array[ $dep_collection_key ],
			','
		);
		$button2_icon_pack_hide_array["no_icon"]             = rtrim(
			$button2_icon_pack_hide_array["no_icon"],
			','
		);
	}
	
}

$button2_icon_pack = new HudsonEdgeMetaField(
	"select",
	"button2_icon_pack",
	"no_icon",
	esc_html__( "Button 2 Icon Pack", 'hudson' ),
	esc_html__( "Choose icon pack for first button", 'hudson' ),
	$hudson_edge_icon_collections->getIconCollectionsEmpty( "no_icon" ),
	array(
		"dependence" => true,
		"hide"       => $button2_icon_pack_hide_array,
		"show"       => $button2_icon_pack_show_array
	)
);

$edgtSlideButtons->addChild(
	"button2_icon_pack",
	$button2_icon_pack
);

if ( is_array( $hudson_edge_icon_collections->iconCollections ) && count( $hudson_edge_icon_collections->iconCollections ) ) {
	//foreach icon collection we need to generate separate container that will have dependency set
	//it will have one field inside with icons dropdown
	foreach ( $hudson_edge_icon_collections->iconCollections as $collection_key => $collection_object ) {
		$icons_array = $collection_object->getIconsArray();
		
		//get icon collection keys (keys from collections array, e.g 'font_awesome', 'font_elegant' etc.)
		$icon_collections_keys = $hudson_edge_icon_collections->getIconCollectionsKeys();
		
		//unset current one, because it doesn't have to be included in dependency that hides icon container
		unset(
			$icon_collections_keys[ array_search(
				$collection_key,
				$icon_collections_keys
			) ]
		);
		
		$button2_icon_hide_values   = $icon_collections_keys;
		$button2_icon_hide_values[] = "no_icon";
		$button2_icon_container     = new HudsonEdgeContainer(
			"button2_icon_" . $collection_object->param . "_container",
			"button2_icon_pack",
			"",
			$button2_icon_hide_values
		);
		$button2_icon               = new HudsonEdgeMetaField(
			"select",
			"button2_icon_" . $collection_object->param,
			"",
			esc_html__( "Button 2 Icon", 'hudson' ),
			esc_html__( "Choose First Button Icon", 'hudson' ),
			$icons_array,
			array( "col_width" => 3 )
		);
		$button2_icon_container->addChild(
			"button2_icon_" . $collection_object->param,
			$button2_icon
		);
		
		$edgtSlideButtons->addChild(
			"button2_icon_" . $collection_object->param . "_container",
			$button2_icon_container
		);
	}
	
}

$button2_style_container = new HudsonEdgeContainer(
	"button2_style_container",
	"button2_icon_pack",
	"no_icon"
);
$edgtSlideButtons->addChild(
	"button2_style_container",
	$button2_style_container
);

$button2_style = new HudsonEdgeGroup(
	esc_html__( "Button 2 Style", 'hudson' ),
	esc_html__( "Define button 2 style", 'hudson' )
);
$button2_style_container->addChild(
	"button2_style",
	$button2_style
);

$row1 = new HudsonEdgeRow( true );
$button2_style->addChild(
	"row1",
	$row1
);

$slider_button2_icon_color = new HudsonEdgeMetaField(
	"colorsimple",
	"slider_button2_icon_color",
	"",
	esc_html__( "Icon Color", 'hudson' ),
	""
);
$row1->addChild(
	"slider_button2_icon_color",
	$slider_button2_icon_color
);

$slider_button2_icon_hover_color = new HudsonEdgeMetaField(
	"colorsimple",
	"slider_button2_icon_hover_color",
	"",
	esc_html__( "Icon Hover Color", 'hudson' ),
	""
);
$row1->addChild(
	"slider_button2_icon_hover_color",
	$slider_button2_icon_hover_color
);

$slider_button2_icon_size = new HudsonEdgeMetaField(
	"textsimple",
	"slider_button2_icon_size",
	"",
	esc_html__( "Icon Size (px)", 'hudson' ),
	""
);
$row1->addChild(
	"slider_button2_icon_size",
	$slider_button2_icon_size
);

$slider_button2_icon_hover_animation = new HudsonEdgeMetaField(
	"selectblanksimple",
	"slider_button2_icon_hover_animation",
	"",
	esc_html__( "Hover Animtion", 'hudson' ),
	esc_html__( "This is some description", 'hudson' ),
	array(
		"move_icon" => esc_html__( "Move Icon", 'hudson' )
	)
);
$row1->addChild(
	"slider_button2_icon_hover_animation",
	$slider_button2_icon_hover_animation
);

//Slide Content Positioning

$edgtSlideContentPositioning = new HudsonEdgeMetaBox(
	"slides",
	esc_html__( "Slide Content Positioning", 'hudson' )
);
hudson_edge_return_framework_variable()->edgtMetaBoxes->addMetaBox(
	"slides_content_positioning",
	$edgtSlideContentPositioning
);

$edgt_slide_predefined_content_position = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_slide_predefined_content_position",
	"",
	esc_html__( "Predefined content position", 'hudson' ),
	esc_html__( "Choose position of slide content", 'hudson' ),
	array(
		""                     => "",
		"content_bottom_left" => esc_html__( "Bottom Left", 'hudson' ),
		"content_bottom_right" => esc_html__( "Bottom Right", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			""                     => "#edgtf_edgt_slide_predefined_content_position_width_container",
			"content_bottom_left"  => "#edgtf_edgt_slide_predefined_content_position_container",
			"content_bottom_right" => "#edgtf_edgt_slide_predefined_content_position_container"
		),
		"show"       => array(
			""                     => "#edgtf_edgt_slide_predefined_content_position_container",
			"content_bottom_left"  => "#edgtf_edgt_slide_predefined_content_position_width_container",
			"content_bottom_right" => "#edgtf_edgt_slide_predefined_content_position_width_container"
		)
	)
);
$edgtSlideContentPositioning->addChild(
	"edgt_slide_predefined_content_position",
	$edgt_slide_predefined_content_position
);

$edgt_slide_predefined_content_position_width_container = new HudsonEdgeContainerNoStyle(
	"edgt_slide_predefined_content_position_width_container",
	"edgt_slide_predefined_content_position",
	""
);
$edgtSlideContentPositioning->addChild(
	"edgt_slide_predefined_content_position_width_container",
	$edgt_slide_predefined_content_position_width_container
);

$edgt_slide_predefined_content_position_width = new HudsonEdgeMetaField(
	"text",
	"edgt_slide_predefined_content_position_width",
	"",
	esc_html__( "Content Width", 'hudson' ),
	esc_html__( "Enter Width for Content Area (px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgt_slide_predefined_content_position_width_container->addChild(
	"edgt_slide_predefined_content_position_width",
	$edgt_slide_predefined_content_position_width
);

$edgt_slide_predefined_content_position_width_fs = new HudsonEdgeMetaField(
	"text",
	"edgt_slide_predefined_content_position_width_fs",
	"",
	esc_html__( "Content Width (smaller devices)", 'hudson' ),
	esc_html__( "Enter Width for Content Area (px) on smaller devices (1000px - 1350px)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgt_slide_predefined_content_position_width_container->addChild(
	"edgt_slide_predefined_content_position_width_fs",
	$edgt_slide_predefined_content_position_width_fs
);

$edgt_slide_predefined_content_position_container = new HudsonEdgeContainerNoStyle(
	"edgt_slide_predefined_content_position_container",
	"edgt_slide_predefined_content_position",
	"content_bottom_left",
	array( "content_bottom_left", "content_bottom_right" )
);
$edgtSlideContentPositioning->addChild(
	"edgt_slide_predefined_content_position_container",
	$edgt_slide_predefined_content_position_container
);

$edgt_slide_text_alignment = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_slide-content-alignment",
	"",
	esc_html__( "Text Alignment", 'hudson' ),
	esc_html__( "Choose an alignment for the slide text", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$edgt_slide_predefined_content_position_container->addChild(
	"edgt_slide-content-alignment",
	$edgt_slide_text_alignment
);

$edgt_slide_separate_text_graphic = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_slide-separate-text-graphic",
	"no",
	esc_html__( "Separate Graphic and Text Positioning", 'hudson' ),
	esc_html__( "Do you want to separately position graphic and text?", 'hudson' ),
	array(
		"no" => esc_html__( "No", 'hudson' ),
		"yes" => esc_html__( "Yes", 'hudson' )
	),
	array(
		"dependence" => true,
		"hide"       => array(
			""   => "#edgtf_edgt_slide_graphic_positioning_container, #edgtf_edgt_slide_general_animation_separate_container",
			"no" => "#edgtf_edgt_slide_graphic_positioning_container, #edgtf_edgt_slide_general_animation_separate_container"
		),
		"show"       => array(
			"yes" => "#edgtf_edgt_slide_graphic_positioning_container, #edgtf_edgt_slide_general_animation_separate_container"
		)
	)
);
$edgt_slide_predefined_content_position_container->addChild(
	"edgt_slide-separate-text-graphic",
	$edgt_slide_separate_text_graphic
);

$edgt_slide_content_vertical_middle = new HudsonEdgeMetaField(
	"yesno",
	"edgt_slide-content-vertical-middle",
	"no",
	esc_html__( "Vertically Align Content to Middle", 'hudson' ),
	"",
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "#edgtf_edgt_slide-content-vertical-middle-container",
		"dependence_show_on_yes" => "#edgtf_edgt_slide-content-vertical-middle-type-container"
	)
);
$edgt_slide_predefined_content_position_container->addChild(
	"edgt_slide-content-vertical-middle",
	$edgt_slide_content_vertical_middle
);

$edgt_slide_content_vertical_middle_type_container = new HudsonEdgeContainer(
	"edgt_slide-content-vertical-middle-type-container",
	"edgt_slide-content-vertical-middle",
	"no"
);
$edgt_slide_predefined_content_position_container->addChild(
	"edgt_slide-content-vertical-middle-type-container",
	$edgt_slide_content_vertical_middle_type_container
);

$edgt_slide_content_vertical_middle_type = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_slide-content-vertical-middle-type",
	"",
	esc_html__( "Align Content Vertically Relative to the Height Measured From", 'hudson' ),
	"",
	array(
		"bottom_of_header" => esc_html__( "Bottom of Header", 'hudson' ),
		"window_top" => esc_html__( "Window Top", 'hudson' )
	)
);
$edgt_slide_content_vertical_middle_type_container->addChild(
	"edgt_slide-content-vertical-middle-type",
	$edgt_slide_content_vertical_middle_type
);

$edgt_slide_vertical_content_full_width = new HudsonEdgeMetaField(
	"yesno",
	"edgt_slide_vertical_content_full_width",
	"no",
	esc_html__( "Content Holder Full Width", 'hudson' ),
	esc_html__( "Do you want to set slide content holder to full width?", 'hudson' )
);
$edgt_slide_content_vertical_middle_type_container->addChild(
	"edgt_slide_vertical_content_full_width",
	$edgt_slide_vertical_content_full_width
);

$edgt_slide_vertical_content_width = new HudsonEdgeMetaField(
	"text",
	"edgt_slide_vertical_content_width",
	"",
	esc_html__( "Content Width", 'hudson' ),
	esc_html__( "Enter Width for Content Area (%)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgt_slide_content_vertical_middle_type_container->addChild(
	"edgt_slide_vertical_content_width",
	$edgt_slide_vertical_content_width
);

$content_vertical_positioning_group = new HudsonEdgeGroup(
	esc_html__( "Space Around Content in Slide", 'hudson' ),
	esc_html__( "Enter values for margins around slide content", 'hudson' )
);
$edgt_slide_content_vertical_middle_type_container->addChild(
	"content_vertical_positioning_group",
	$content_vertical_positioning_group
);
$row1 = new HudsonEdgeRow( true );
$content_vertical_positioning_group->addChild(
	"row1",
	$row1
);
$edgt_slide_vertical_content_left = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_vertical_content_left",
	"",
	esc_html__( "From Left (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_vertical_content_left",
	$edgt_slide_vertical_content_left
);
$edgt_slide_vertical_content_right = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide_vertical_content_right",
	"",
	esc_html__( "From Right (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide_vertical_content_right",
	$edgt_slide_vertical_content_right
);

$edgt_slide_content_vertical_middle_container = new HudsonEdgeContainer(
	"edgt_slide-content-vertical-middle-container",
	"edgt_slide-content-vertical-middle",
	"yes"
);
$edgt_slide_predefined_content_position_container->addChild(
	"edgt_slide-content-vertical-middle-container",
	$edgt_slide_content_vertical_middle_container
);

$edgt_slide_content_full_width = new HudsonEdgeMetaField(
	"yesno",
	"edgt_slide-content-full-width",
	"no",
	esc_html__( "Content Holder Full Width", 'hudson' ),
	esc_html__( "Do you want to set slide content holder to full width?", 'hudson' ),
	array(),
	array(
		"dependence"             => true,
		"dependence_hide_on_yes" => "#edgtf_edgt_slide_content_width_container",
		"dependence_show_on_yes" => ""
	)
);
$edgt_slide_content_vertical_middle_container->addChild(
	"edgt_slide-content-full-width",
	$edgt_slide_content_full_width
);

$edgt_slide_content_width_container = new HudsonEdgeContainer(
	"edgt_slide_content_width_container",
	"edgt_slide-content-full-width",
	"yes"
);
$edgt_slide_content_vertical_middle_container->addChild(
	"edgt_slide_content_width_container",
	$edgt_slide_content_width_container
);

$edgt_slide_content_width = new HudsonEdgeMetaField(
	"text",
	"edgt_slide-content-width",
	"",
	esc_html__( "Content Holder Width", 'hudson' ),
	esc_html__( "Enter Width for Content Holder Area (%)", 'hudson' ),
	array(),
	array( "col_width" => 3 )
);
$edgt_slide_content_width_container->addChild(
	"edgt_slide-content-width",
	$edgt_slide_content_width
);

$content_positioning_group = new HudsonEdgeGroup(
	esc_html__( "Space Around Content in Slide", 'hudson' ),
	esc_html__( "Enter values for margins around slide content", 'hudson' )
);
$edgt_slide_content_vertical_middle_container->addChild(
	"content_positioning_group",
	$content_positioning_group
);
$row1 = new HudsonEdgeRow( true );
$content_positioning_group->addChild(
	"row1",
	$row1
);
$edgt_slide_content_top = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-content-top",
	"",
	esc_html__( "From Top (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-content-top",
	$edgt_slide_content_top
);
$edgt_slide_content_left = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-content-left",
	"",
	esc_html__( "From Left (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-content-left",
	$edgt_slide_content_left
);
$edgt_slide_content_bottom = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-content-bottom",
	"",
	esc_html__( "From Bottom (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-content-bottom",
	$edgt_slide_content_bottom
);
$edgt_slide_content_right = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-content-right",
	"",
	esc_html__( "From Right (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-content-right",
	$edgt_slide_content_right
);

$edgt_slide_graphic_positioning_container = new HudsonEdgeContainer(
	"edgt_slide_graphic_positioning_container",
	"edgt_slide-separate-text-graphic",
	"no"
);
$edgt_slide_content_vertical_middle_container->addChild(
	"edgt_slide_graphic_positioning_container",
	$edgt_slide_graphic_positioning_container
);

$edgt_slide_graphic_alignment = new HudsonEdgeMetaField(
	"selectblank",
	"edgt_slide-graphic-alignment",
	"",
	esc_html__( "Graphic Alignment", 'hudson' ),
	esc_html__( "Choose an alignment for the slide graphic", 'hudson' ),
	array(
		"left" => esc_html__( "Left", 'hudson' ),
		"center" => esc_html__( "Center", 'hudson' ),
		"right" => esc_html__( "Right", 'hudson' )
	)
);
$edgt_slide_graphic_positioning_container->addChild(
	"edgt_slide-graphic-alignment",
	$edgt_slide_graphic_alignment
);

$graphic_positioning_group = new HudsonEdgeGroup(
	esc_html__( "Graphic Positioning", 'hudson' ),
	esc_html__( "Positioning for slide graphic", 'hudson' )
);
$edgt_slide_graphic_positioning_container->addChild(
	"graphic_positioning_group",
	$graphic_positioning_group
);

$row1 = new HudsonEdgeRow();
$graphic_positioning_group->addChild(
	"row1",
	$row1
);

$edgt_slide_content_top = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-graphic-top",
	"",
	esc_html__( "From Top (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-graphic-top",
	$edgt_slide_content_top
);

$edgt_slide_content_left = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-graphic-left",
	"",
	esc_html__( "From Left (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-graphic-left",
	$edgt_slide_content_left
);

$edgt_slide_content_bottom = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-graphic-bottom",
	"",
	esc_html__( "From Bottom (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-graphic-bottom",
	$edgt_slide_content_bottom
);

$edgt_slide_content_right = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-graphic-right",
	"",
	esc_html__( "From Right (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row1->addChild(
	"edgt_slide-graphic-right",
	$edgt_slide_content_right
);

$row2 = new HudsonEdgeRow( true );
$graphic_positioning_group->addChild(
	"row2",
	$row2
);

$edgt_slide_content_width = new HudsonEdgeMetaField(
	"textsimple",
	"edgt_slide-graphic-width",
	"",
	esc_html__( "Width (%)", 'hudson' ),
	esc_html__( "This is some description", 'hudson' )
);
$row2->addChild(
	"edgt_slide-graphic-width",
	$edgt_slide_content_width
);

$edgt_slide_content_padding = new HudsonEdgeMetaField(
	"text",
	"edgt_slide-content-text-padding",
	"",
	esc_html__( "Slide Content Text Padding", 'hudson' ),
	esc_html__( "Define some padding around text (top right bottom left) - Default value is 0px 0px 0px 0px", 'hudson' )
);
$edgtSlideContentPositioning->addChild(
	"edgt_slide-content-text-padding",
	$edgt_slide_content_padding
);